// Module PI : Peida Interactive     PIGraphic3D
// Trace graphiques 3D               R. Ansari  06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHIC3D_H_SEEN
#define PIGRAPHIC3D_H_SEEN

#include "pisysdep.h"
#include "pigraphuc.h"


class PIGraphic3D : public PIGraphicUC 
{
public:
                     PIGraphic3D(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual           ~PIGraphic3D();

  virtual int        kind();

//  Definition du systeme de projection 3D-2D
  virtual void       Set3DCS_Obs(float xo, float yo, float zo, float teta, float phi, float psi, 
                                 float dax, float day, float co, float dco=0.2);
  virtual void       Set3DCS(float xc, float yc, float zc, float xo, float yo, float zo, 
                             float dax, float day, float dco=0.2, float psi=0.);
  virtual bool       Get3DCS(float& xc, float& yc, float& zc, float& xo, float& yo, float& zo,  
                             float& teta, float& phi, float& psi, float& dax, float& day, float& co, float& dco);

  virtual void       PrintCS();  // Pour debugger
  virtual void       RotateObserver(float teta, float phi, float psi=0., bool rel=true);
  virtual void       RotateObject(float teta, float phi, bool rel=true);
  virtual void       ZoomInOut(float fco, float fdax, float fday, bool rel=true);

  virtual void       C3DC2ObsCS(float x, float y, float z, float& xp, float& yp, float& zp);
  virtual void       Proj3DC2GrC(float x, float y, float z, float& xpix, float& ypix);
  
  virtual void       DrawString3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0, char* s);
  virtual void       DrawOpaqueString3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0, char* s);
  virtual void       DrawLine3D(PIGrCoord x1, PIGrCoord y1, PIGrCoord z1, 
                                PIGrCoord x2, PIGrCoord y2, PIGrCoord z2);
  virtual void       DrawPolygon3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n);  
  virtual void       DrawFPolygon3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n);  
  virtual void       DrawMarker3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0);
  virtual void       DrawMarkers3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n);
  
protected:
  double xO, yO, zO;  // Position observateur = camera
  double xC, yC, zC;  // Position centre du champ
  double tO,fO,pO;    // Orientation observateur (Teta, Phi, Psi, Angles d Euler)
  double daxO, dayO;  // Demi-ouverture de la camera suivant les deux axes de projection (xp/zp, yp/zp) 
  double lCO, dlCO;   // Distance Camera-Centre du champ et profondeur de champ 
  double RE[3][3];    // Matrice de rotation  
  bool sO;            // Vrai si fait par Set3DCS_Obs()
};

#endif
