// Module PI : Peida Interactive     PIGraphic3D
// Trace graphiques 3D               R. Ansari  06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdio.h>
#include <math.h>
#include "pigraph3d.h"

/* --Methode-- */
PIGraphic3D::PIGraphic3D(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
        : PIGraphicUC(g, x0, y0, dx, dy)
{
  int i,j;
  for(i=0; i<3; i++) 
    for(j=0; j<3; j++)  RE[i][j] = 0.;
  RE[0][0] = RE[1][1] = RE[2][2] = 1.;
  xO = yC = 0.; zO = -10.;
  xC = yC = zC = 0.;
  tO = fO = pO = 0.; 
  daxO = dayO = 0.25;
  lCO = 10.;  dlCO = 0.2;  
  sO = false;
}

/* --Methode-- */
PIGraphic3D::~PIGraphic3D()
{
}

/* --Methode-- */
int PIGraphic3D::kind() 
{
  return PI_3DGraphics; 
}

static float deuxpi = 2*M_PI;
static double ddeuxpi = 2*M_PI;

/* --Methode-- */
void PIGraphic3D::Set3DCS_Obs(float xo, float yo, float zo, float teta, float phi, float psi, 
                              float dax, float day, float co, float dco)
{
  sO = true;
  xO = xo;  yO = yo;  zO = zo;
  while (teta < 0.)  teta += deuxpi;
  while (teta > deuxpi)  teta -= deuxpi;
  if (teta > M_PI)  { teta = M_PI-teta;  phi = phi+M_PI; }
  while (phi < 0.)  phi += deuxpi;
  while (phi > deuxpi) phi -= deuxpi;
  tO = teta;  fO = phi;  pO = psi;
  if (dax < 0.) dax = -dax;
  if (day < 0.) day = -day;
  daxO = dax;  dayO = day;
  lCO = co;   dlCO = dco;
// Si on ne met  kAxeDirLtoR, le repere semble etre ds le sens inverse -> kAxeDirRtoL  , Reza 16/10/98
  SetUCS(-dax, dax, -day, day, kAxeDirRtoL, kAxeDirDownUp);
  double ct = cos((double)tO);
  double st = sin((double)tO);
// (Teta,Phi) = Direction de visee 
// Les angles d'Euler correspondants sont Teta, Phi+Pi/2
// Le Pi/2 vient que les rotations d'euler se font dans l'ordre
//  Autour de oZ d'angle Phi, autour de oN (nouvel axe X) d'angle Teta
//  Autour du nouvel axe Z (x3) d'angle Psi
  double cf = cos((double)fO+M_PI_2);
  double sf = sin((double)fO+M_PI_2);
  double cp = cos((double)pO);
  double sp = sin((double)pO);
  RE[0][0] = cf*cp-sf*ct*sp;     RE[0][1] = sf*cp+cf*ct*sp;      RE[0][2] = st*sp;
  RE[1][0] = -cf*sp-sf*ct*cp;    RE[1][1] = -sf*sp+cf*ct*cp;     RE[1][2] = st*cp;
  RE[2][0] = sf*st;              RE[2][1] = -cf*st;              RE[2][2] = ct;
  cf = cos((double)fO);
  sf = sin((double)fO);
  zC = ct*lCO+zO;
  xC = st*cf*lCO+xO;
  yC = st*sf*lCO+yO;
}

/* --Methode-- */
void PIGraphic3D::Set3DCS(float xc, float yc, float zc, float xo, float yo, float zo, 
                          float dax, float day, float dco, float psi)
{
  sO = false;
  xO = xo;  yO = yo;  zO = zo;
  xC = xc;  yC = yc;  zC = zc;
  double dx,dy,dz,dl;
// On calcule le vecteur  OC  Observateur -> Centre du champ, ca nous donne donc teta,phi de visee
  dx = xc-xo;  dy = yc-yo;  dz = zc-zo;
  if (dax < 0.) dax = -dax;
  if (day < 0.) day = -day;
  daxO = dax;  dayO = day;  
// Si on ne met  kAxeDirLtoR, le repere semble etre ds le sens inverse -> kAxeDirRtoL  , Reza 16/10/98
  SetUCS(-dax, dax, -day, day, kAxeDirRtoL, kAxeDirDownUp);
  lCO = sqrt(dx*dx+dy*dy+dz*dz);
  if (lCO < 1.e-6) {
    printf("PIGraphic3D::Set3DCS()/Warning : Length(CO) = %g -> CS par defaut \n", lCO);
    int i,j;
    for(i=0; i<3; i++) 
      for(j=0; j<3; j++)  RE[i][j] = 0.;
    RE[0][0] = RE[1][1] = RE[2][2] = 1.;
    xO = yC = 0.; zO = -10.;
    xC = yC = zC = 0.;
    tO = fO = pO = 0.; 
    daxO = dayO = 0.25;
    lCO = 10.;  dlCO = 0.2;      
    return;
  }
  dlCO = dco;
  double lxy = sqrt(dx*dx+dy*dy);
  double ct,st,cf,sf;
  ct = dz/lCO;
  st = sqrt(1-ct*ct);
  pO = psi;
  tO = acos(ct);
  if (lxy < 1.e-6) { fO = 0.;  cf = 0.;  }
  else {  cf = dx/lxy;  fO = acos(cf);  if (dy < 0.)  fO = ddeuxpi-fO;   }
// (Teta,Phi) = Direction de visee 
// Les angles d'Euler correspondants sont Teta, Phi+Pi/2
// Le Pi/2 vient que les rotations d'euler se font dans l'ordre
//  Autour de oZ d'angle Phi, autour de oN (nouvel axe X) d'angle Teta
//  Autour du nouvel axe Z (x3) d'angle Psi
  cf = cos((double)fO+M_PI_2);
  sf = sin((double)fO+M_PI_2);
  double cp = cos((double)psi);
  double sp = sin((double)psi);
  RE[0][0] = cf*cp-sf*ct*sp;     RE[0][1] = sf*cp+cf*ct*sp;      RE[0][2] = st*sp;
  RE[1][0] = -cf*sp-sf*ct*cp;    RE[1][1] = -sf*sp+cf*ct*cp;     RE[1][2] = st*cp;
  RE[2][0] = sf*st;              RE[2][1] = -cf*st;              RE[2][2] = ct;
}


/* --Methode-- */
bool PIGraphic3D::Get3DCS(float& xc, float& yc, float& zc, float& xo, float& yo, float& zo, 
                          float& teta, float& phi, float& psi, float& dax, float& day, float& co, float& dco)
{
  xc = xC;  yc = yC;  zc = zC;
  xo = xO;  yo = yO;  zo = zO;
  teta = tO;  phi = fO;  psi = pO;
  dax = daxO;   day = dayO;
  co = lCO;     dco = dlCO;
  return(sO);
}

/* --Methode-- */
void PIGraphic3D::PrintCS()
{
if (sO)  printf("PIGraphic3D::PrintCS() : Set3DCS_Obs(...) \n");
else  printf("PIGraphic3D::PrintCS() : Set3DCS(...) \n");
printf("C: %g %g %g ->O: %g %g %g - T,P= %g %g %g lCO= %g %g  |  %g %g - %g %g \n", 
        xC,yC,zC, xO, yO, zO, tO, fO, pO, lCO, dlCO, xOrg, xScale, yOrg, yScale ); 
printf("RE[3][3]=  %g %g %g | %g %g %g | %g %g %g\n", 
        RE[0][0], RE[0][1], RE[0][2], RE[1][0], RE[1][1], RE[1][2], RE[2][0], RE[2][1], RE[2][2]); 
float x,y,z,xp,yp,zp, xpix, ypix;
x = xC, y = yC, z= zC;
C3DC2ObsCS(x, y, z, xp, yp, zp);
Proj3DC2GrC(x, y, z, xpix, ypix);
printf("C -> %g %g %g -> %g %g \n", xp, yp, zp, xpix, ypix); 
x = xC+1, y = yC, z= zC;
C3DC2ObsCS(x, y, z, xp, yp, zp);
Proj3DC2GrC(x, y, z, xpix, ypix);
printf("C+(1,0,0) -> %g %g %g -> %g %g ", xp, yp, zp, xpix, ypix); 
x = xC, y = yC+1, z= zC+1;
C3DC2ObsCS(x, y, z, xp, yp, zp);
Proj3DC2GrC(x, y, z, xpix, ypix);
printf("C+(0,1,1) -> %g %g %g -> %g %g \n", xp, yp, zp, xpix, ypix); 
}

/* --Methode-- */
void PIGraphic3D::RotateObserver(float teta, float phi, float psi, bool rel)
// Positionne l'observateur (la camera) de maniere a ce que la direction de 
// visee soit tO=teta, pO=phi (rel=false) / tO+=teta pO+=phi (rel=true) 
// en conservant le centre de champ fixe  
{
  if (rel) {
    teta += tO;
    phi += fO;
    psi += pO;
    }
  while (teta < 0.)  teta += deuxpi;
  while (teta > deuxpi)  teta -= deuxpi;
  if (teta > M_PI)  { teta = M_PI-teta;  phi = phi+M_PI; }
  float xo,yo,zo; 
  zo = -cos((double)teta)*lCO+zC;
  xo = -sin((double)teta)*cos((double)phi)*lCO+xC;
  yo = -sin((double)teta)*sin((double)phi)*lCO+yC;
  Set3DCS(xC,yC,zC, xo,yo,zo, daxO, dayO, dlCO, psi);
}

/* --Methode-- */
void PIGraphic3D::RotateObject(float teta, float phi, bool rel)
// Positionne l'objet (centre du champ) de maniere a ce que la direction de 
// visee soit tO=teta, pO=phi (rel=false) / tO+=teta pO+=phi (rel=true) 
// en conservant la position de l'observateur fixe.  
{
  if (rel) {
    teta += tO;
    phi += fO;
    }
  while (teta < 0.)  teta += deuxpi;
  while (teta > deuxpi)  teta -= deuxpi;
  if (teta > M_PI)  { teta = M_PI-teta;  phi = phi+M_PI; }
  float xc,yc,zc; 
  zc = cos((double)teta)*lCO+zO;
  xc = sin((double)teta)*cos((double)phi)*lCO+xO;
  yc = sin((double)teta)*sin((double)phi)*lCO+yO;
  Set3DCS(xc,yc,zc, xO,yO,zO, daxO, dayO, dlCO, pO);
}

/* --Methode-- */
void PIGraphic3D::ZoomInOut(float fco, float fdax, float fday, bool rel)
{
  if (fco < 0.001) fco = 1.;
  if (fdax < 0.001) fdax = 1.;
  if (fday < 0.001) fday = 1.;
  double dl;
  if (rel) {
    dl = fco*lCO;  
    fdax *= daxO;
    fday *= dayO;
  }
  else dl = fco; 
  float xo,yo,zo; 
  if (dl < 1.e-5) dl = 1.e-5;
  zo = zC-cos((double)tO)*dl;
  xo = xC-sin((double)tO)*cos((double)fO)*dl;
  yo = yC-sin((double)tO)*sin((double)fO)*dl;
  Set3DCS(xC,yC,zC, xo,yo,zo, fdax, fday, dl, pO);
//  Set3DCS_Obs(xo, yo, zo, tO, fO, pO, daxO*fda, dayO*fda, dl, dlCO);
}

/* --Methode-- */
void PIGraphic3D::C3DC2ObsCS(float x, float y, float z, float& xp, float& yp, float& zp)
{
  double xc, yc, zc;
  xc = x-xO;   yc = y-yO;    zc = z-zO;
  xp = RE[0][0]*xc+RE[0][1]*yc+RE[0][2]*zc;
  yp = -RE[1][0]*xc+RE[1][1]*yc+RE[1][2]*zc;  
  zp = RE[2][0]*xc+RE[2][1]*yc+RE[2][2]*zc;
}

/* --Methode-- */
void PIGraphic3D::Proj3DC2GrC(float x, float y, float z, float& xpix, float& ypix)
{
  double xc, yc, zc;
  float xp, yp, zp;
  xc = x-xO;   yc = y-yO;    zc = z-zO;
  xp = RE[0][0]*xc+RE[0][1]*yc+RE[0][2]*zc;   
  yp = RE[1][0]*xc+RE[1][1]*yc+RE[1][2]*zc;
  zp = RE[2][0]*xc+RE[2][1]*yc+RE[2][2]*zc;
  if ((zp>-1.e-6) && (zp < 1.e-6))   // Protection Divide/0
    { xpix = ypix = 0.;   return; }
  xpix = (float)(xOrg + (xp/zp)*xScale);
  ypix = (float)(yOrg + (yp/zp)*yScale);
//  printf("-DBG-Proj3DC2GrC() %g %g %g -> %g %g %g -> %g %g %g -> (%g %g)\n", x,y,z,xc,yc,zc,xp,yp,zp,xp/zp,yp/zp);
//  printf("-DBG- ... (%g %g %g - %g %g) %g %g - %g %g -> %g %g \n", xO,yO,zO, tO,fO, xOrg, yOrg,xScale,yScale ,xpix,ypix);
}

/* --Methode-- */
void PIGraphic3D::DrawString3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0, char* s)
{
  if (!mGrC) return;
  float xf, yf;
  Proj3DC2GrC(x0, y0, z0, xf, yf);
  mGrC->DrawString(xf, yf, s);
  return;
}

/* --Methode-- */
void PIGraphic3D::DrawOpaqueString3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0, char* s)
{
  if (!mGrC) return;
  float xf, yf;
  Proj3DC2GrC(x0, y0, z0, xf, yf);
  mGrC->DrawOpaqueString(xf, yf, s);
  return;
}

/* --Methode-- */
void PIGraphic3D::DrawLine3D(PIGrCoord x1, PIGrCoord y1, PIGrCoord z1, 
                             PIGrCoord x2, PIGrCoord y2, PIGrCoord z2)
{
  if (!mGrC) return;
  float xf1, yf1, xf2, yf2;
  Proj3DC2GrC(x1, y1, z1, xf1, yf1);
  Proj3DC2GrC(x2, y2, z2, xf2, yf2);
//  printf("-DBG-DrawLine3D() : %g %g %g -> %g %g | %g %g %g -> %g %g\n", 
//         (float)x1, (float)y1, (float)z1, xf1, yf1, 
//         (float)x2, (float)y2, (float)z2, xf2, yf2 );
  mGrC->DrawLine(xf1, yf1, xf2, yf2);
}

#define NMXMULTP  30   // Pour multipoint sans new

/* --Methode-- */
void PIGraphic3D::DrawPolygon3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n)
{
  PIGrCoord xc[NMXMULTP], yc[NMXMULTP];
  PIGrCoord *pxc, *pyc;
  int i;
  float xf, yf;
 
  if (!mGrC) return;
  if (n <= 0)  return;

  if (n > NMXMULTP) { pxc = new PIGrCoord[n];  pyc = new PIGrCoord[n];  }
  else { pxc = xc;  pyc = yc; }
  for(i=0; i<n; i++) {
    Proj3DC2GrC(x[i], y[i], z[i], xf, yf);
    pxc[i] = xf;  pyc[i] = yf; 
  }
  mGrC->DrawPolygon(pxc, pyc, n, false);
  if (n > NMXMULTP) { delete[] pxc;  delete[] pyc; }
  return;
}


/* --Methode-- */
void PIGraphic3D::DrawFPolygon3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n)
{
  PIGrCoord xc[NMXMULTP], yc[NMXMULTP];
  PIGrCoord *pxc, *pyc;
  int i;
  float xf, yf;
 
  if (!mGrC) return;
  if (n <= 0)  return;

  if (n > NMXMULTP) { pxc = new PIGrCoord[n];  pyc = new PIGrCoord[n];  }
  else { pxc = xc;  pyc = yc; }
  for(i=0; i<n; i++) {
    Proj3DC2GrC(x[i], y[i], z[i], xf, yf);
    pxc[i] = xf;  pyc[i] = yf; 
  }
  mGrC->DrawFPolygon(pxc, pyc, n, false);
  if (n > NMXMULTP) { delete[] pxc;  delete[] pyc; }
  return;
}

/* --Methode-- */
void PIGraphic3D::DrawMarker3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0)
{
  if (!mGrC) return;
  float xf, yf;
  Proj3DC2GrC(x0, y0, z0, xf, yf);
  mGrC->DrawMarker(xf, yf);
  return;
}

/* --Methode-- */
void PIGraphic3D::DrawMarkers3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n)
{
  PIGrCoord xc[NMXMULTP], yc[NMXMULTP];
  PIGrCoord *pxc, *pyc;
  int i;
  float xf, yf;
 
  if (!mGrC) return;
  if (n <= 0)  return;

  if (n > NMXMULTP) { pxc = new PIGrCoord[n];  pyc = new PIGrCoord[n]; }
  else { pxc = xc;  pyc = yc; }
  for(i=0; i<n; i++) {
    Proj3DC2GrC(x[i], y[i], z[i], xf, yf);
    pxc[i] = xf;  pyc[i] = yf; 
  }
  mGrC->DrawMarkers(pxc, pyc, n);
  if (n > NMXMULTP) { delete[] pxc;  delete[] pyc; }
  return;
}
