//  Classe de base d'objets application pour 
//  les programmes graphiques interactives
//
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

//++
// Class	PIApplication
// Lib		PI
// include	piapplgen.h
//
//	Classe de base pour l'objet application. L'objet PIApplication 
//	doit tre cr avant la cration des autres objets de PI.
//	La classe "PIApplication" a implmentation dpendante 
//	du systeme utilis (Mac, XWindow, ...). La classe "PIApplicationGen" 
//	est la classe qui dfinit l'interface, et ne doit pas tre instancie 
//	directement (Mthodes virtuelles pures). Les objets instancis sont 
//	de la classes "PIApplication" et le fichier entte correspondant est 
//	"PIAPP_H" dfini dans "pisysdep.h".
//--
//++
// Links	Parents
// PIMsgHandler
//--
//++
// Titre	Constructeur
//--
//++
// PIApplication(int sx=200, int sy=30, int narg=0, char *arg[]=NULL)
//	Constructeur. "sx,sy" est la taille de la fentre principale
//	(ou PIContainer) associe  l'application. Des arguments
//	optionnels, par exemple celle de la ligne de commande peuvent 
//	tre transmis  l'objet PIApplication. Dans le cas d'Unix/XWindow
//	par exemple, les options reconnues par la Xtoolkit peuvent 
//	tre passes  l'objet application.
//--

//++
// Titre	Mthodes
//--
//++
// PIContainer*   MainWin()
//	Renvoie le pointeur de l'objet "PIContainer" associ  l'application.
// PIMenubar*   Menubar()
//	Renvoie le pointeur de l'objet "PIMenubar" associ  l'application.
// void AppendMenu(PIMenu *pdm)
//	Ajoute le "PIMenu *pdm" au Menubar de l'application. Le titre 
//	du menu dans le menubar est le nom de l'objet menu. 
// void Run() Stop
//	Dmarre, arrte la boucle d'vnements.
//--


#include "piapplgen.h"

// Variable qui contient le pointeur de l'application courante
// permet de recuperer la taille pref pour la fonction globale 
static PIApplicationGen * curapp = NULL;

PIApplicationGen::PIApplicationGen()
:topcont(NULL), menubar(NULL), mState(0)
{
curapp = this;   
}

PIApplicationGen::~PIApplicationGen()
{}


void PIApplicationGen::AppendMenu(PIMenu *pdm)
{
if (menubar)
  menubar->AppendMenu(pdm);
return;
}

//++
// void SetReady()
//	Modifie l'tat global de l'application - Pssage  l'tat normal,
//	prt  traiter les actions utilisateur.
// void SetBusy()
//	Passage en mode de calcul - La souris prend la forme de la montre
//	pour la fentre principale
// void SetBlocked()
//	Passge en mode bloqu. La barre de menu devient insensible
// int GetState()
//	Renvoie l'tat global de l'application "(kReadyState, kBusyState, kBlockedState)".
//--
void PIApplicationGen::SetReady()
{
mState = kReadyState;
}

void PIApplicationGen::SetBusy()
{
mState = kBusyState;
}

void PIApplicationGen::SetBlocked()
{
mState = kBlockedState;
}

int PIApplicationGen::GetState()
{
return mState;
}

//++
// Titre	Redirection StdOut, StdErr
//	Il est possible de rediriger les flots de sortie
//	standard et d'erreur vers un objet PIConsol.
//--

//++
// void  RedirectOutStream(PIConsole* cons, unsigned char va= PIVA_Def)
//	Redirige le flot de sortie ("stdout" sous Unix) vers l'objet 
//	PIConsole "cons". si "cons==NULL", redirection 
//	sur le flot original.
//
// void  RedirectErrStream(PIConsole* cons, unsigned char va= PIVA_Def)
//	Redirige le flot des messages d'erreur ("stderr" sous Unix) 
//	vers l'objet PIConsole "cons". si "cons==NULL", redirection
//	 sur le flot original.
//--

//++
// Titre	Informations globales
//	Les mthodes suivantes permettent d'acceder aux informations  
//	concernant l'cran (tailles, ...). Des fonctions globales sont 
//	prvues ( "PIApplicationPrefCompSize()" et "PIApplicationScreenSize()" )
//	afin d'obtenir ces informations sans avoir besoin d'une instance de la 
//	classes application.
//--
//++
// void  PIApplicationPrefCompSize(int& szx, int& szy)
//	Fonction globale
// void  PrefCompSize(int& szx, int& szy)
//	Renvoie la taille prfre pour les composantes standard. "szx,szy" 
//	est la taille (en pixels) pour un champ texte, ou un bouton "(PIText, PIButton)" 
//	avec l'tiquette ou un contenu de 6 caractres (Ex: Cancel).
//
// void  PIApplicationScreenSize(int& szx, int& szy)
//	Fonction globale
// void  ScreenSize(int& szx, int& szy)
//	Renvoie la taille de l'cran en pixels 
//
// void  PIApplicationScreenSizeMM(int& szx, int& szy)
//	Fonction globale
// void  ScreenSizeMM(int& szx, int& szy)
//	Renvoie la taille de l'cran en mm 
// 
// void  PIApplicationScreenResolution(int& resolx, int& resoly)
//	Fonction globale
// void  ScreenResolution(int& resolx, int& resoly)
//	Renvoie la resolution de l'ecran en pixels / cm
//  
//--

void     PIApplicationPrefCompSize(int& szx, int& szy)
{
szx = szy = 10;
if (curapp)  curapp->PrefCompSize(szx, szy);
return; 
}
void     PIApplicationScreenSize(int& szx, int& szy)
{
szx = szy = 500;
if (curapp)  curapp->ScreenSize(szx, szy);
return; 
}
void     PIApplicationScreenSizeMM(int& szx, int& szy)
{
szx = szy = 400;
if (curapp)  curapp->ScreenSizeMM(szx, szy);
return; 
}
void     PIApplicationScreenResolution(int& resolx, int& resoly)
{
resolx = resoly = 30;
if (curapp)  curapp->ScreenResolution(resolx, resoly);
return; 
}
