#ifndef PICMAPBASE_H_SEEN
#define PICMAPBASE_H_SEEN

#include "pisysdep.h"
#include <string>
#include <string.h>


 
struct PIColor {
  unsigned short red;
  unsigned short green;
  unsigned short blue;
};

class PIColorMapGen {
public:
  PIColorMapGen();  
  PIColorMapGen(int id, int nc, string const& nom);  
  virtual ~PIColorMapGen();

  int Type() const          {return mType;}
  int NCol() const          {return mNCol;}
  string const& Nom() const {return mNom;}

  virtual PIColor GetColor(int n)=0;
  virtual bool AllocColor(PIColor const& col, int index)=0;
  virtual void FreeColors()=0;     // Desalloue les couleurs

  virtual long   TotNbColors()=0;   // Donne le nombre total de couleurs disponibles
  virtual int   NbAllocColors()=0;  // Nb de couleurs deja allouees 
protected:
  void CopyFromGen(PIColorMapGen*);
  virtual void CopyFrom(PIColorMapGen*)=0;
  

  int    mNCol;
  int    mType;
  string mNom;
  
};


#endif
