// This may look like C code, but it is really -*- C++ -*-
//  Adaptateurs et Drawers divers pour Outils PEIDA++
//                             R. Ansari  06-08/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIPODRW_H_SEEN
#define PIPODRW_H_SEEN

#include "pidrawer.h"
#include "parradapter.h"
#include "cvector.h"
#include "matrix.h"
#include "histos2.h"

class PIFuncDrawer : public PIDrawer {
public:
  typedef double(*FUNC)(double);
                     PIFuncDrawer(FUNC);
  virtual           ~PIFuncDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
protected:
  FUNC               mFunc;
};

class GeneralFunction;
class PIGFFDrawer : public PIDrawer {
public:
                     PIGFFDrawer(GeneralFunction*);
  virtual           ~PIGFFDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       SetParms(double const*);
protected:
  GeneralFunction*    mFunc;
  int                 mNParms;
  double*             mParms;
};


// Adaptateur de vecteurs Peida++ a P1DArrayAdapter
class POVectorAdapter : public P1DArrayAdapter {
public :
                  POVectorAdapter(Vector* v, bool ad=false);
  virtual         ~POVectorAdapter();
  virtual float   Value(int i);

protected:
  bool aDel;
  Vector* mVec;
};

// Adaptateur d'Histo-2D Peida++ a P2DArrayAdapter
class POH2DAdapter :  public P2DArrayAdapter {
public :
                  POH2DAdapter(Histo2D* h2d, bool ad=false);
  virtual         ~POH2DAdapter();

  virtual float   Value(int ix, int iy);   

protected:
  bool aDel;
  Histo2D* mH2d;
};

// Adaptateur de matrice Peida++ a P2DArrayAdapter
// Attention MatrixAdapter(X=Colonne, Y= Row) = Matrix(row, col)  
class POMatrixAdapter :  public P2DArrayAdapter {
public :
                  POMatrixAdapter(Matrix* mtx, bool ad=false);
  virtual         ~POMatrixAdapter();

  virtual float   Value(int ix, int iy);   

protected:
  bool aDel;
  Matrix* mMtx;
};


#endif
