#include "picmap.h"

#define  MXMAPIDS   10 
static   int    MapNCols[MXMAPIDS] = {256, 256, 256, 256, 256, 256, 256, 256, 256, 256};
static   char*  MapNoms[MXMAPIDS]  = {"Grey32","InvGrey32","ColRJ32","ColBR32",
                               "ColRV32", "Grey128", "InvGrey128", "ColRJ128",
                               "ColBR128", "Col16"};
static   CMapId MapIds[MXMAPIDS] = { CMAP_GREY32, CMAP_GREYINV32, CMAP_COLRJ32,
                               CMAP_COLBR32, CMAP_COLRV32, CMAP_GREY128, 
                               CMAP_GREYINV128, CMAP_COLRJ128, CMAP_COLBR128,  
                               CMAP_COL16 } ;

static   int mColTNums[8192];   // Max 8192 tables differentes pour le moment  
static   int CTNum = 0;        //  Numero des tables ds mColTNum - s'incremente a chaque creation 

static   int NMaxTableAuto = 0;
static   PIColorMap* mMaps[10] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL };

PIColorMap::PIColorMap(CMapId id)
: PIColorMapNative()
{
   int k, kdx;
   string mnom;

   if (NMaxTableAuto == 0) { //  Il faut allouer les tables de depart
     if ( TotNbColors() > 2048 ) NMaxTableAuto = MXMAPIDS-1;
     else NMaxTableAuto = 3; 
     for(k=0; k<NMaxTableAuto; k++)  { 
        mnom = MapNoms[k]; 
        mMaps[k] = new PIColorMap(MapIds[k], MapNCols[k], mnom);
     }
   }

//  Protection pour valeur de Id  
   for(kdx=0; kdx<MXMAPIDS; kdx++)  if (id == MapIds[kdx])  break;
   if (kdx == MXMAPIDS)  { id = MapIds[0];  kdx = 0; }
   for(k=0; k<NMaxTableAuto; k++)  
     if (id == mMaps[k]->Type()) {
       CopyFrom(mMaps[k]);  
       mCTId = mMaps[k]->mCTId;  mColTNums[mCTId]++;
       break;
     }
   if (Type() != id)  {  // Table pas encore trouve dans la liste
     k = NMaxTableAuto;
     if (!mMaps[k] || mMaps[k]->Type() != id) {
       if ( mMaps[k] ) {  
         mColTNums[mMaps[k]->mCTId] = 1;  // Je force a liberer les couleurs 
         delete mMaps[k] ;
       }
       mnom = MapNoms[kdx];
       mMaps[k] = new PIColorMap(MapIds[kdx],  MapNCols[kdx], mnom); 
     }
    CopyFrom(mMaps[k]);  
    mCTId = mMaps[k]->mCTId;  mColTNums[mCTId]++;
   }
}


PIColorMap::PIColorMap(string const& nom, int nCol)
: PIColorMapNative(CMAP_OTHER, nCol, nom)
{
  MakeColMap();
  mCTId = CTNum;
  mColTNums[mCTId] = 1;
  CTNum++;
}

PIColorMap::PIColorMap(CMapId id, int nCol, string const& nom)
: PIColorMapNative(id, nCol, nom)
{
  MakeColMap();
  mCTId = CTNum;
  mColTNums[mCTId] = 1;
  CTNum++;
//  printf("PIColorMap/Debug-Creation:  %d %d - %s ", Type(), NCol(), Nom().c_str());
//  printf("  ..CRE.. %d %d \n", CTNum-1, mColTNums[CTNum-1]);
}

PIColorMap::PIColorMap(PIColorMap& cm)
{
  CopyFrom(&cm);
  mCTId = cm.mCTId;
  mColTNums[mCTId]++;
}

PIColorMap::~PIColorMap()
{
//  printf("PIColorMap/Debug-Delete:  %d %d - %s ", Type(), NCol(), Nom().c_str());
//  printf("...DEL.CTNum,mColTNums= %d %d (%d %d) ", 
//        CTNum, mColTNums[CTNum], mCTId,mColTNums[mCTId] );
  mColTNums[mCTId]--; 
  if ( mColTNums[mCTId] == 0 )  { FreeColors();  mColTNums[mCTId] = 0; }
//  printf("\n");
}



void PIColorMap::CleanColorMaps()
{
  int k;
  for(k=0; k<MXMAPIDS; k++)  { 
    if (!mMaps[k])  continue;
    mMaps[k]->FreeColors();
    delete mMaps[k];
  }
}

/*  Definition d' une table de couleurs  R G B   */

static float R_RGB1[16] =
{0.0,0.00,0.0,0.0,0.0,0.00,0.0,0.6,0.8,1.0,1.00,1.0,0.75,1.0,0.85,1.0};
static float G_RGB1[16] =
{0.0,0.00,0.0,0.8,1.0,1.00,1.0,0.8,0.8,1.0,0.75,0.6,0.00,0.0,0.0,0.0};
static float B_RGB1[16] =
{0.0,0.75,1.0,1.0,1.0,0.75,0.0,0.0,0.0,0.0,0.00,0.5,0.75,1.0,0.0,0.0};



void PIColorMap::MakeColMap()
{
  PIColor mycol;
  int i,j,k;

  switch (mType) {

    case CMAP_GREY32 :
      for(i=0; i<32; i++) {
        mycol.red = mycol.green = mycol.blue = 3535+(i*62000/32);
        for(k=0; k<8; k++)     AllocColor(mycol, i*8+k);
      }
      break;
    

    case CMAP_GREYINV32 :
      for(i=0; i<32; i++) {
        mycol.red = mycol.green = mycol.blue = 3535+(i*62000/32);
        for(k=0; k<8; k++)     AllocColor(mycol, mNCol-(i*8+k)-1);
      }
      break;

    case CMAP_COL16 :
      for(i=0; i<16; i++) {
        mycol.red = (int)(R_RGB1[i]*65535.);
        mycol.green = (int)(G_RGB1[i]*65535.);
        mycol.blue =(int)(B_RGB1[i]*65535.) ;
        for(k=0; k<16; k++)     AllocColor(mycol, i*16+k);
      }
      break;

    case CMAP_COLRJ32 :
      for( i=0; i<32; i++) {
        if (i < 12)  { 
          mycol.green = mycol.blue = 0;  
          mycol.red = 21535+(i*4000);  }
        else if (i < 24) { 
          mycol.blue = 0;   mycol.red = 65535;
          mycol.green = 21535+(i-12)*4000;  }
        else { 
          mycol.green = mycol.red = 65535;
          mycol.blue = 17535+(i-23)*6000; }
        for(k=0; k<8; k++)   AllocColor(mycol, i*8+k); 
        }
      break;

  case CMAP_COLBR32 :
    for( i=0; i<32; i++) {
      if (i < 5) { 
        mycol.green = mycol.red = 0;    // Du bleu sombre au bleu clair
        mycol.blue = 5535+i*15000; }
      else if (i < 10) { 
        mycol.blue = 65535;             // Plein bleu - On rajoute du vert -> bleu clair
        mycol.green = 5535+(i-5)*9000;
        mycol.red = 0;  }
      else if (i < 15) { 
        mycol.blue = 60000-(i-10)*15000;   // On passe au vert
        mycol.green = 41535+(i-10)*6000;
        mycol.red = 0;  }
      else if (i < 21) { 
        mycol.blue = 0;
        mycol.green = 65535;               // Plein vert, on rajoute du rouge -> jaune
        mycol.red = 5535+(i-15)*12000;  }
      else if (i < 27) {  
        mycol.blue = 0;                     //  On diminue vert -> Orange
        mycol.green = 60000-(i-21)*12000;
        mycol.red = 65535-(i-21)*2000;  }
      else {
        mycol.blue = 0;                     // Plein rouge
        mycol.green = 0;
        mycol.red = 57535+(i-27)*2000; }

      for(k=0; k<8; k++)   AllocColor(mycol, i*8+k); 
      }
    break;

  case CMAP_COLRV32 :
    for( i=0; i<32; i++) {
      if (i < 8) {
        mycol.green = 15000+(i*5000); mycol.blue = 0;  
        mycol.red = 15000+(i*5000); }
      else if (i < 21) {
        mycol.green = 50000-(i-7)*5000;   
        if (mycol.green < 0)  mycol.green = 0;
        mycol.blue = 0;
        mycol.red = 53535+(i-8)*1000;  }
      else { 
        mycol.green = 0;  mycol.red = 65535;
        mycol.blue = 15535+(i-21)*5000; }

      for(k=0; k<8; k++)   AllocColor(mycol, i*8+k); 
      }
    break;

    case CMAP_GREY128 :
      for(i=0; i<128; i++) {
        mycol.red = mycol.green = mycol.blue = 2035+(i*500);
        for(k=0; k<2; k++)     AllocColor(mycol, i*2+k);
      }
      break;
    

    case CMAP_GREYINV128 :
      for(i=0; i<128; i++) {
        mycol.red = mycol.green = mycol.blue = 2035+(i*500);
        for(k=0; k<2; k++)     AllocColor(mycol, mNCol-(i*2+k)-1);
      }
      break;

    case CMAP_COLRJ128 :
      for( i=0; i<128; i++) {
        if (i < 48)  { 
          mycol.green = mycol.blue = 0;  
          mycol.red = 5375+(i*1280);  }
        else if (i < 96) { 
          mycol.blue = 0;   mycol.red = 65535;
          mycol.green = 5375+((i-48)*1280);  }
        else { 
          mycol.green = mycol.red = 65535;
          mycol.blue = 3535+(i-96)*2000; }
        for(k=0; k<2; k++)   AllocColor(mycol, i*2+k); 
        }
      break;

    case CMAP_COLBR128 :
      for( i=0; i<128; i++) {
        if (i < 20) { 
          mycol.green = mycol.red = 0;  // Du bleu sombre au bleu clair
          mycol.blue = 2835+i*3300; }
        else if (i < 36) { 
          mycol.blue = 65535;           // Plein bleu - On rajoute du vert -> bleu clair
          mycol.green = 3000+(i-20)*2000;
          mycol.red = 0;  }
        else if (i < 56) { 
          mycol.blue = 64600-(i-36)*3400;    // On passe au vert 
          mycol.green = 32300+(i-36)*1700;
          mycol.red = 0;  }
        else if (i < 81) {         
          mycol.blue = 0;              // Plein vert, on rajoute du rouge -> jaune
          mycol.green = 65535;
          mycol.red = 3135+(i-56)*2600;  }
        else if (i < 96) { 
          mycol.blue = 0;
          mycol.green = 63535-(i-80)*2000;
          mycol.red = 65535;  }
        else if (i < 112) { 
          mycol.blue = 0;
          mycol.green = 30000-(i-96)*2000;
          mycol.red = 65535-(i-96)*1000;  }
        else {
          mycol.blue = 0;
          mycol.green = 0 ;
          mycol.red = 50535+(i-112)*1000; }

        for(k=0; k<2; k++)   AllocColor(mycol, i*2+k); 
      }
      break;

  default :
    for(i=0; i<mNCol; i++) {
      mycol.green = mycol.red = mycol.blue = 0;
      AllocColor(mycol, i);
    }
    break;
  }
}
