#! /bin/csh 

set opt = 'slball'

if ($#argv < 1)   then 
  echo 'Error Arg/ Usage: mkslb.csh slb/slbext/slbpi/slball'
  exit 0
endif

set opt = $1

set cw = `pwd`

echo '---- CWD= ' $cw

set LIBXPIPATH = '-L/usr/X11/lib '
set LIBXPILIST = '-lXm -lXt -lX11'
set XPILIBS = "$LIBXPIPATH $LIBXPILIST"

set LIB = $DPCDEVREP/IRIX64-CC/Libs/
set SLB = $DPCDEVREP/IRIX64-CC/ShLibs/
set OBJ = $DPCDEVREP/IRIX64-CC/Objs/

set EXTLIBPL = -L${EXTLIBDIR}/IRIX64-CC/Libs/
set EXTSLBPL = -L${EXTLIBDIR}/IRIX64-CC/ShLibs/

set EXTLIBL  = "${EXTLIBPL} -lcfitsio -lfftw -lrfftw -lxastro -lcomplib.sgimath"
set EXTSLBL  = "${EXTSLBPL} -lcfitsio -lfftw -lrfftw -lxastro -lcomplib.sgimath"


set OBJBaseTools = `cat ./BaseTools/objlist.list `
set OBJSysTools = `cat ./SysTools/objlist.list `
set OBJSUtils = `cat ./SUtils/objlist.list `
set OBJTArray = `cat ./TArray/objlist.list `
set OBJNTools = `cat ./NTools/objlist.list `
set OBJHiStats = `cat ./HiStats/objlist.list `
set OBJSkyMap = `cat ./SkyMap/objlist.list ` 
set OBJSamba = `cat ./Samba/objlist.list `
set OBJSkyT = `cat ./SkyT/objlist.list `
set ALLOBJS = ($OBJBaseTools $OBJSysTools $OBJSUtils $OBJTArray $OBJNTools  $OBJHiStats  $OBJSkyMap $OBJSamba $OBJSkyT)
	
set OBJFitsIOServer = `cat ./FitsIOServer/objlist.list `
set OBJIFFTW = `cat ./IFFTW/objlist.list `
set OBJLinAlg = `cat ./LinAlg/objlist.list `
set OBJXAstroPack = `cat ./XAstroPack/objlist.list `
set ALLEXTOBJS = ( $OBJFitsIOServer $OBJIFFTW $OBJLinAlg $OBJXAstroPack )

set OBJPI = `cat ./PI/objlist.list `
set OBJPIext = `cat ./PIext/objlist.list `
set ALLPIOBJS = ( $OBJPI $OBJPIext )

# echo $ALLOBJS 

#   Si nous sommes en 64 bits
if ( $?SOPHYA_SGI64 ) then 
  set SHLCC = "CC -64 -shared"
else
  set SHLCC = "CC -shared"
endif

echo 'Going to ' $OBJ
cd  $OBJ

if ( ($opt == 'slball') || ($opt == 'slb') ) then
  echo ' ======> Building slb' 
  set cmd = "$SHLCC -o ${SLB}libsophya.so -all"
  set cmde = "-notall -lpthread -lm"
  echo $cmd $ALLOBJS $cmde
  $cmd $ALLOBJS $cmde
endif

if ( ($opt == 'slball') || ($opt == 'slbext') ) then
  echo ' ======> Building slbext' 
  set cmd = "$SHLCC -o ${SLB}libextsophya.so -all"
  set cmde = " ${EXTLIBL} -notall -L${SLB} -lsophya -lm"
  echo $cmd $ALLEXTOBJS $cmde
  $cmd $ALLEXTOBJS $cmde
endif

if ( ($opt == 'slball') || ($opt == 'slbpi') ) then
  echo ' ======> Building slbpi' 
  set cmd = "$SHLCC -o ${SLB}libPI.so -all"
  set cmde = " ${EXTLIBL} -notall -L${SLB} -lextsophya -lsophya ${XPILIBS} -lpthread -lm"
  echo $cmd $ALLPIOBJS $cmde
  $cmd $ALLPIOBJS $cmde
endif



echo 'Back to' $cw
cd $cw 

exit 
