#ifndef PSFILE_H_SEEN
#define PSFILE_H_SEEN

/*
 *  PSFile.h
 * 
 *  14/06/96, 19/06/96
 *
 *  Gestion des fichier .ps et .eps
 *
 *     - L'unite de mesure est lUnite Courante (UC)
 *        Au depart, 1UC == 1cm 
 *     - Les reperes sont orientes a la maniere XWindow
 * 
 *  17/02/97 : modification des constructeurs(1-->eps,2-->ps)
 *             ajout du type enum orientation
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "defs.h"
#ifdef __mac__
#include <stat.h>
#endif
#include "pisysdep.h"


#include "pigraphgen.h"      // Types enumeres repris de Peida:PIFontSize...
#include PICMAP_H

#include <list>
#if defined(__KCC__)
#include <list.h>
#endif

enum PIPaperSize { PI_A4 = 1, PI_A3 = 2, PI_A5 = 3, PI_NotDefPaperSize = 0};

enum PIOrientation { PI_Landscape = 0, PI_Portrait = 1, PI_Auto = 2 } ;


/*
 *#define PAGE_WIDTH   21.0    == 595 points 
 *#define PAGE_HEIGHT  29.7    == 842 points 
 *#define PORTRAIT  1
 *#define LANDSCAPE 0
 */



/* Valable pour une page, ou un bloc */
/*typedef struct {
 *  float X0;          Coordonnes sommet NO  
 *  float Y0;           en unites courantes  
 *  float Tx;          Format                
 *  float Ty;           en unites courantes  
 *  float Dx;          Coord sommet SE       
 *  float Dy;           en unites courantes  
 *  int orientation;   LANDSCAPE OU PORTRAIT 
 *} Format;
 */

/*
 *typedef struct{
 *    char *Name;
 *    int  Tx;     En 1/72e de pouce  !! 
 *    int  Ty;     unite naturelle de ps 
 *} PIMedia;
 */



class PSFile{

public:
    /* Production fichier eps */
    PSFile (const char * FileName, float sc = 1.0);
    /* Production fichier ps  */
    PSFile (const char * FileName, PIOrientation orientation, 
	    PIPaperSize paperSize= PI_A4, 
	    float marginX = 5.0, float marginY = 5.0 ) ;

    virtual      ~PSFile();

    virtual int     IsEPS();
    virtual const char*   GetFileName();


    /*    virtual Format* GetFormat(); */
    /* Attributs graphiques */
    virtual PIColors    GetDrawColor();
    virtual PIColors    GetFillColor();
    virtual PIFontAtt   GetFontAtt();
    virtual PIFontSize  GetFontSize();
    virtual PILineAtt   GetLineAtt();
    virtual PIMarker    GetMarker();

    virtual void  NewPage(float Dx, float Dy, PIOrientation orientation);
    virtual void  EndPage();
    virtual void  NewBloc(float x0, float y0, float Tx, float Ty,
			  float Dx, float Dy);
    virtual void  EndBloc();

    virtual void SelForeground(PIColorMap& cmap, int cid) ; 
    virtual void SelBackground(PIColorMap& cmap, int cid) ; 

    /* Trace */
    virtual void  DrawString  (float x,  float y, const char *s, 
			       PIColors DrawColor  = PI_NotDefColor, 
			       PIFontAtt FontAtt   = PI_NotDefFontAtt, 
			       int FontSize        = 8);
    virtual void  DrawLine    (float x1, float y1, float x2, float y2, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawBox     (float x0, float y0, float Tx, float Ty, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFBox    (float x0, float y0, float Tx, float Ty, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawCircle  (float x0, float y0, float r, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFCircle (float x0, float y0, float r,
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawPolygon (float *x, float *y, int n,
			       PIColors DrawColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt, 
                               bool cinc = true);
    virtual void  DrawFPolygon(float *x, float *y, int n,
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt, 
                               bool cinc = true);
    virtual void  DrawMarker  (float x0, float y0, 
			       PIMarker MrkType    = PI_NotDefMarker, 
			       PIColors DrawColor  = PI_NotDefColor,
			       int MarkerSize=14);
    virtual void  DrawMarkers (float *x0, float *y0, int n,
			       PIMarker MrkType    = PI_NotDefMarker,
			       PIColors DrawColor  = PI_NotDefColor,
			       int MarkerSize=14); 

    virtual void  Image(float x0, float y0, float Tx, float Ty,
			int Nx, int Ny,
			unsigned char *pict,
			PIColorMap *mColorMap);

#if !defined(__DECCXX) && !defined(__aCC__)
private:
#endif


    /* Blocs */
    typedef struct {
	int    num;
	char*  label;
	float  X0, Y0;            /* coordonnees sommet NO */
	float  Tx, Ty;            /* Format */
	float  Dx, Dy;            /* Repere utilisateur */
	long  begin,end,tmp;   /* offsets dans le fichier */
    } Bloc ;
    typedef list<Bloc> BlocList;  /* STL */


    /* Pages */
    typedef struct {
	int num;
	int BlocCounter;
	float Dx,Dy;              /* Sommet SE (unites utilisateur) */ 
	PIOrientation orientation;
	long  begin, end, tmp;    /* Offsets dans le fichier */
	BlocList mBlocList;       /* Page == Liste de blocs  */
    } Page ;
    typedef list<Page> PageList;  /* STL */

#if defined(__DECCXX) || defined(__aCC__)
private:
#endif

    /* Fichier ps/eps */
    FILE *   mPSFile;
    const char *   mPSFileName;
    float    Tw,Th ;              /* Format, en cm */
    float    WMargin,HMargin ;    /* Marges minimales */
    int      isEPS;               /* Vrai si PostScript Encapsule */
    long     boundingBox;         /* Endroit ou est specifiee la bb */
    float    scale;               /* boundingbox = Dx*scale ; Dy*scale */
    PIPaperSize mPaperSize ; 
    int      PageCounter;         /* nbr pages */
    int      FileEmpty;
    Page*    currentPage;        /* Avant empilage */
    Bloc*    currentBloc;        /* Avant empilage */
    PageList mPageList;          /* Fichier == Liste de pages */


    /* Attributs graphiques, initialises par constructeur */
    enum PIColors    mDrawColor;  /* Couleur de trace courante */
    enum PIColors    mFillColor;  /* Couleur de remplissage courante */
    enum PIFontAtt   mFontAtt; 
    enum PIFontSize  mFontSize; 
    enum PILineAtt   mLineAtt;    /* Epaisseur d une ligne */
    enum PIMarker    mMarker;     /* Marker courant */
    int              mMarkerSize; /* Taille (en points) du marker courant */
    bool setFontDone ; /* Pour forcer la selection de Marker apres DrawString() */
} ;


#endif/* PSFILE_H_SEEN */
