// Module PI : Peida Interactive      PIEventHandler
// Classe Gestionnaire d'evenements (Ecran/Clavier/Souris)
//                                    R.Ansari  12/98 
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pievthandler.h"

//++
// Class	PIEventHandler
// Lib		PI
// include	pievthandler.h
//
//	Classe fournissant les services ncessaires  la cration de
//	gestionnaire d'vnements cran-clavier-souris.
//--
//++
// Links	Parents
// PIMsgHandler
//--
//++
// Links	Voir aussi
// PIWdg
//--
//++
// Titre	Constructeur, mthodes
//--
//++
// PIEventHandler(PIMsgHandler* par=NULL, PIMessage msg = 0)
//	Constructeur. "par" est le gestionnaire de message parent, et
//	"msg" le message associ.
//
// void	  SetMsg(PIMessage msg = 0)
//	Modification du message associ.
// PIMessage  Msg() 
//	Renvoie le message associ.
//--



/* --Methode-- */
PIEventHandler::PIEventHandler(PIMsgHandler* par, PIMessage msg)
	: PIMsgHandler(par)
{
SetMsg(msg);
curwdg = NULL;
event = PIEvent_None;
posx = posy = 0;
key = 0;
keymod = PIKM_Blank;
evttime = 0;
}

/* --Methode-- */
PIEventHandler::~PIEventHandler()
{
}

//++
// Titre	Traitement des vnements
//--
//++
// void Draw(PIGraphic* g, int x0, int y0, int dx, int dy)
//	Mthode spcialise appele pour retracer le contenu 
//	d'une partie de l'objet "PIWdg" auquel est attach l'objet
//	"PIEventHandler". "PIGraphic* g" fournit les services de 
//	trac graphique et "(x0, y0), "dx * dy" dfinissent le 
//	rectangle  retracer. L'implementation par dfaut ne 
//	fait rien.
//
// void ProcessEvent()
//	Cette mthode est appele pour le traitement de tous 
//	les autres types d'vnements. L'implementation par dfaut 
//	ne fait rien. 
//--


/* --Methode-- */
void PIEventHandler::Draw(PIGraphic*, int, int, int, int)
{
return;
}

/* --Methode-- */
void PIEventHandler::ProcessEvent()
{
return;
}

/* --Methode-- */
void PIEventHandler::SetCurrentWdg(PIWdg* wdg)
{
curwdg = wdg;
}


//++
// Titre	Description de l'vnement
//--
//++
// PIWdg*  CurrentWdg()
//	L'objet "PIWdg" source de l'vnement.
// PIEventMask EventType()
//	Type de l'vnement :
//|	PIEvent_Draw 
//|	PIEvent_Resize , PIEvent_Enter , PIEvent_Leave
//|	PIEvent_ButxPress , PIEvent_ButxRelease  (x=1,2,3)
//|	PIEvent_PtrMove , PIEvent_PtrxMove (x=1,2,3)
//|	PIEvent_Keyboard
//
// int GetPosX()
//	Position X de la souris
// int GetPosY()
//	Position Y de la souris
// int GetKey()
//	Code touche du clavier. Code ASCII des caractres ordinaires, ou l'une des constantes:
//|	PIK_Return , PIK_Enter
//|	PIK_BackSpace , PIK_Delete
//|	PIK_Tab , PIK_Escape
//|	PIK_Up , PIK_Down
//|	PIK_Right , PIK_Left
//|	PIK_Previous , PIK_Next
//
// PIKeyModifier GetKeyMod()
//	Code d'une des touches <Shift>, <Alt>, <Cntl> si appuye en mme temps.
//|	PIKM_Blank , PIKM_Shift , PIKM_Alt , PIKM_Cntl
//
// unsigned long GetEventTime()
//	Temps de l'action en millisecondes.
//--

/* --Methode-- */
void PIEventHandler::SetEventInfo(PIEventMask evt, int px, int py, 
                                  int k, PIKeyModifier km, unsigned long tm)
{
event = evt;
posx = px; posy = py;
key = k;
keymod = km;
evttime = tm;
}

