// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIFont 
// LAL (Orsay) / IN2P3-CNRS              R. Ansari  99

#ifndef PIFONTGEN_H_SEEN
#define PIFONTGEN_H_SEEN

#include "pisysdep.h"

enum PIFontName { PI_DefaultFont = 0, PI_CourierFont = 1, PI_HelveticaFont = 2, 
                  PI_TimesFont = 3, PI_SymbolFont = 4};

enum PIFontSize { PI_NotDefFontSize = -1, 
		  PI_TinySizeFont = 1,
                  PI_SmallSizeFont = 2, PI_NormalSizeFont = 3, 
                  PI_BigSizeFont = 4, PI_HugeSizeFont = 5 };

enum PIFontAtt { PI_NotDefFontAtt = -1,
                 PI_RomanFont = 1, PI_BoldFont = 2, PI_ItalicFont = 4, 
		 PI_BoldItalicFont = 6 };

class PIFontGen
{
public:
		PIFontGen(PIFontName fn = PI_DefaultFont);
		PIFontGen(int npt, PIFontName fn = PI_DefaultFont, 
                          PIFontAtt fa = PI_RomanFont);
// PIFont doit avoir un constructeur de copie, et l'operateur egal de defini
// ainsi que l'operateur test d'egalite
  virtual	~PIFontGen();

  virtual void		SetFont(PIFontName fn)		= 0;
  virtual void		SetFontAtt(PIFontAtt fa)	= 0;
  virtual void		SetFontSz(PIFontSize fs)	= 0;
  virtual void		SetFontSzPt(int npt)		= 0;

  virtual PIFontName    GetFontName()			= 0;
  virtual PIFontAtt     GetFontAtt()			= 0;
  virtual int		GetFontSize()			= 0;

  virtual int		GetFontHeight(int& asc, int& desc)	= 0;
  virtual int		GetStringWidth(char const* s)		= 0;
};

#endif      // PIFONTGEN_H_SEEN
