// Module PI : Peida Interactive     PIPeriodX
// Classe d'objets periodiques - X11 - R. Ansari 96-98
// LAL (Orsay) / IN2P3-CNRS    DAPNIA/CEA (Saclay)      

#include "piwdgx.h"
#include "piperiodx.h"

//++
// Class	PIPeriodic
// Lib		PI
// include	piperiodx.h
//
//	Classe d'objets avec une mthode "DoPeriodic()" appele priodiquement
//	 intrevalle rgulier. Implmentation de la classe "Periodic" compatible
//	avec la boucle d'vnements.
//--
//++
// Links	Parents
// Periodic
//--

//++
// Titre	Constructeur
//	Voir la classe "Periodic" pour les mthodes.
//--
//++
//  Periodic(int dt, UsPeriodicAction act=NULL, void * usp=NULL)
//	Constructeur avec un intervalle de temps en secondes "dt".
//	Il est possible de spcifier une fonction "UsPeriodicAction" avec
//	un argument "usp" qui sera appele rgulierement.
//--

/* Nouvelle-Fonction */
static void xttimer_action(XtPointer usd, XtIntervalId * /*tid*/)
{
PIPeriodX * pip;
XtIntervalId id;
pip = (PIPeriodX *)usd;
pip->DoPeriodic();
int szx, szy, szf;
XtAppContext * appctx = PIXtAppCtx(szx, szy, szf);
id = XtAppAddTimeOut(*appctx, pip->Intervalms(), xttimer_action, pip);
pip->SetTimerId(id);
return;
}


/* --Methode-- */
PIPeriodX::PIPeriodX(int dt, UsPeriodicAction act, void * usp)
: Periodic(dt, act, usp)
{
}

/* --Methode-- */
PIPeriodX::~PIPeriodX()
{
if (mFgact) Stop();
}

/* --Methode-- */
void PIPeriodX::Start(int dt)
{
if (mFgact) return;
if (dt > 0)  { mDt = dt;  mDtms = dt*1000; }

int szx,szy,szf;
XtAppContext * appctx = PIXtAppCtx(szx, szy, szf);
mTId = XtAppAddTimeOut(*appctx, Intervalms(), xttimer_action, this);
mFgact = true;
return;
}

void
PIPeriodX::Stop()
{
if(mFgact)
  XtRemoveTimeOut(mTId);
mFgact = false;
return;
}

