#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "machine.h"

#include "perrors.h"
#include "ctimer.h"

#include "nbmath.h"

#include "pistdimgapp.h"
#include "nobjmgr.h"
#include "servnobjm.h"



/* ........................................................... */
/*  Classe ObjMgrWind  interface de gestion d'objets nommes    */
/* ........................................................... */

/* --Methode-- */
ObjMgrWind::ObjMgrWind(PIStdImgApp *par)
: PIWindow((PIMsgHandler *)par, "objmgr", PIWK_dialog, 
           400, 300, 250, 250)
{
int i;
dap = par;

int bsx, bsy;
int tsx, tsy;
int spx, spy;
// On definit la taille a partir de la taille par defaut des composantes 
PIApplicationPrefCompSize(bsx, bsy);
spx = bsx/4;   spy = bsy/3;
tsx = 5*bsx+6*spx;  tsy = 7*bsy+4*spy;
SetSize(tsx,tsy);
objlist = new PIList(this, "objlist", tsx-spx, tsy-4*spy-bsy, spx/2, spy/2);
objlist->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
objlist->SetBorderWidth(2);

int py = tsy-2*spy-bsy;
int px = spx;
mBut[0] = new PIButton(this, "Display", 100, bsx, bsy, px, py);   px += (bsx+spx);
mBut[1] = new PIButton(this, "Print",   200, bsx, bsy, px, py);   px += (bsx+spx);
mBut[2] = new PIButton(this, "SavePPF", 300, bsx, bsy, px, py);   px += (bsx+spx);
mBut[3] = new PIButton(this, "Delete",  400, bsx, bsy, px, py);   px += (bsx+spx);
mBut[4] = new PIButton(this, "Dismiss", 900, bsx, bsy, px, py);   px += (bsx+spx);

for(i=0; i<5; i++)
  mBut[i]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

// FinishCreate(); pas necessaire ?
}

/* --Methode-- */
ObjMgrWind::~ObjMgrWind()
{
int i;
delete objlist;
for(i=0; i<5; i++)  delete mBut[i];
}

/* --Methode-- */
void ObjMgrWind::Show()
{
dap->SetBlocked();
PIWindow::Show();
return;
}

/* --Methode-- */
void ObjMgrWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{

  // PIMessage ssg = ModMsg(msg);
msg = UserMsg(msg);
if (msg == 900)  {
  dap->SetReady();
  this->Hide();
  return;
}

string nom = "";
if ( (msg == 100) || (msg == 200) || (msg == 300) || (msg == 400) ) {
  string sel = objlist->GetSelectionStr();
  //  size_t p = sel.find_first_not_of(" \t");
  //  if (p<0) p = 0;
  size_t q = sel.find_first_of(" \t");
  if (q < 0)   q = sel.length(); 
  nom = sel.substr(0, q);
}

NamedObjMgr* om = dap->ObjMgr();
if (om == NULL)  return;
if (nom == "")  return;

switch (msg)
  {
  case 100:
    om->DisplayObj(nom);
    break;
  case 200:
    om->PrintObj(nom);
    break;
  case 300:
    if (dap->mPpfout)  om->SaveObj(nom, *(dap->mPpfout));
    break;
  case 400:
    om->DelObj(nom);
    break;

  case 900:
    dap->SetReady();
    Hide();
    break;

  default:    
    //    printf("DEBUG/ObjMgrW::Process %d %d \n", (int)msg, (int)ssg); 
    break;
  }
    
return;
}


/* ........................................................... */
/*  Classe PPInMgrWind  interface de gestion d'objets nommes    */
/* ........................................................... */

/* --Methode-- */
PPInMgrWind::PPInMgrWind(PIStdImgApp *par)
: PIWindow((PIMsgHandler *)par, "PPF-FileManager", PIWK_dialog, 
           400, 300, 250, 250)
{
int i;
dap = par;

int bsx, bsy;
int tsx, tsy;
int spx, spy;
// On definit la taille a partir de la taille par defaut des composantes 
PIApplicationPrefCompSize(bsx, bsy);
spx = bsx/4;   spy = bsy/3;
bsx *= 1.25;
ttx = tsx = 3*bsx+8*spx;   tty = tsy = 7*bsy+5*spy;
SetSize(tsx,tsy);

mLab[0] = new PILabel(this, "filename", tsx-spx, bsy-spy, spx/2, spy/2);
mLab[0]->SetLabel("");
mLab[0]->SetBinding(PIBK_elastic,PIBK_fixed, PIBK_elastic,PIBK_fixed);
mLab[0]->SetBorderWidth(1);

polx = spx/2;  poly = bsy+1.5*spy;
tolx = tsx-spx;   toly = tsy-2*bsy-5*spy;
int py = tsy-2*spy-bsy;
int px = 2*spx;
mBut[0] = new PIButton(this, "Read", 2500, bsx, bsy, px, py);   px += (bsx+2*spx);
mBut[1] = new PIButton(this, "ReadAll", 2600, bsx, bsy, px, py);   px += (bsx+2*spx);
mBut[2] = new PIButton(this, "Close", 2700, bsx, bsy, px, py);   px += (bsx+2*spx);

for(i=0; i<3; i++)
  mBut[i]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
  
objlist = NULL;
mLab[1] = NULL;
mPin = NULL;

//   FinishCreate(); pas necessaire 
}

/* --Methode-- */
PPInMgrWind::~PPInMgrWind()
{
int i;
if (objlist) delete objlist;
delete mLab[0];
for(i=0; i<3; i++)  delete mBut[i];
}

/* --Methode-- */
void PPInMgrWind::SetFile(string flnm)
{
char strg[128];
char* nom;
char  noms[32];
int i, cid, key, ln;

bool ok = true;

TRY {
  mPin = new PInPersist(flnm);
}  CATCH(merr) 
  { printf("ObjMgrWind::SetFile Exception= %ld (%s) \n", (long)merr, PeidaExc(merr)); 
  ok = false; } ENDTRY;

if (!ok) { mPin = NULL;  dap->SetReady(); return; }

if (mPin->NbTags() < 1) {
  delete mPin;   mPin = NULL;
  dap->ObjMgr()->ReadObj(flnm);
  return;
}

if (objlist)  delete objlist;
SetSize(ttx,tty);
mLab[0]->SetLabel(flnm);
objlist = new PIList(this, "infileobjlist", tolx, toly, polx, poly);
objlist->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
objlist->SetBorderWidth(2);


for(i=0; i<mPin->NbTags(); i++) {
  key = mPin->TagKey(i, cid, ln); 
  if (ln <= 0)  nom = "?";
  else { strncpy(noms, mPin->TagName(i).c_str(), 31);  noms[31] = '\0'; nom = noms; }
  sprintf(strg, "%s  (T=%s, Key=%d)",  nom, dap->ObjMgr()->GetServiceObj()->PClassIdToClassName(cid), key);
  objlist->AppendItem(strg, 5000+i);
}

}

/* --Methode-- */
void PPInMgrWind::Show()
{
if (mPin == NULL)   return;
dap->SetBlocked();
PIWindow::Show();
return;
}

/* --Methode-- */
void PPInMgrWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{

int sel;
msg = UserMsg(msg);

if (msg == 2700)  {
  delete mPin;  mPin = NULL;
  delete objlist; objlist = NULL;
  dap->SetReady();
  this->Hide();
  return;
}

NamedObjMgr* om = dap->ObjMgr();
switch (msg)
  {
  case 2500:
    sel = (PIMessage)objlist->GetSelection() - 5000;
    if (sel >= 0) om->ReadObj((*mPin), sel);
    break;
  case 2600:
    om->ReadObj((*mPin), -1);
    dap->SetReady();
    this->Hide();
    break;

  default:    
    break;
  }
    
return;
}
