#include <stdio.h>
#include "pistlist.h"

 
/* --Methode-- */
PIStarList::PIStarList(StarList* stl, bool ad)
: PIDrawer(), mStL(stl)
{
  mAdDO = ad;   
  if (stl == NULL) return;
  SetFluxLimits(1., -1.);
}

PIStarList::~PIStarList()
{
  if (mAdDO && mStL)  delete mStL;
}

/* --Methode-- */
void  PIStarList::SetFluxLimits(float fmin, float fmax, int nl, bool dispflx, bool refr)
{
  if (!mStL)  return;  
  if (fmin < fmax)  { mFmin = fmin;  mFmax = fmax; }
  else mStL->CalcFluxLimits(mFmin, mFmax);
  if (mFmin < 1.e-10)  mFmin = 1.e-10;
  if (mFmax <= mFmin)  mFmax = 1.5*mFmin;
  mDLgF = log10((double)mFmax/(double)mFmin);
  if (mDLgF < 1.e-10)  mDLgF = 1.e-10;
  mF0 = mFmin;
  if (nl < 1)  nl = 1;
  if (nl > 20)  nl = 20;
  mNLev = nl;  
  mDspFV = dispflx;
  if (refr)  Refresh();
  return;
}


/* --Methode-- */
void PIStarList::UpdateLimits()
{
  if (!mStL) return;

  // Commencer par trouver nos limites
  float dx, dy;
  double x1, x2, y1, y2;
  mStL->CalcXYLimits(x1, x2, y1, y2);
  
  dx = 0.02*(x2-x1);
  dy = 0.02*(y2-y1);
  
  SetLimits(x1-dx, x2+dx, y1-dy, y2+dy); 
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


/* --Methode-- */
void PIStarList::Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{
BStar *sti;
float xp,yp,flx;
int sz;
char buff[128];
int nok, nl2;

if (!mStL) return;

int msz = mMSz;
if (msz < 1) msz = 1;
PIMarker mrk = (mMrk != PI_NotDefMarker) ? mMrk : PI_FCircleMarker;
// g->SelFont();
nok = 0;  nl2 = mNLev*2-1;
for (int i=0; i<mStL->NbStars(); i++) {
  sti = mStL->Star(i);
  if ( !(sti->Nice(BStar::flagOK)) )  continue;
  flx = sti->Flux();
  if ( (flx < mFmin) || (flx > mFmax) )  continue;
  xp = sti->PosX();   yp = sti->PosY();
  if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
  nok++;
  sz = (int)((log10((double)flx/mF0))/mDLgF*(double)nl2-0.01) + msz;
  if (sz < 2)  g->SelMarker(sz, PI_DotMarker);
  else g->SelMarker(sz, mrk);
  g->DrawMarker((double)xp,(double)yp ); 
  if (mDspFV) {  
    sprintf(buff," F=%g", flx);
    float dx,dy;
    g->DGrC2UC(sz, 4, dx, dy);
    g->DrawString(xp+dx, yp-dy, buff);
    } 
  }

/*
sprintf(buff, "StarList:  NbStars= %d  NDisp= %d", (int)mStL->NbStars(), nok);
g->BaseGraphic()->DrawString(15,15,buff);
sprintf(buff, "FMin= %g  FMax= %g Nl= %d Sz0= %d", mFmin, mFmax, mNLev, mMSz0);
g->BaseGraphic()->DrawString(15,30,buff);
*/

}

