#ifndef PINTUPLE3D_H
#define PINTUPLE3D_H

#include "ntuple.h"
#include "pi3ddrw.h"

class PINTuple3D : public PIDrawer3D {
public:
                     PINTuple3D(NTuple* nt, bool ad=false);
  virtual           ~PINTuple3D();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       UpdateLimits();
  
          void       SelectXYZ(const char* px, const char* py, const char* pz);
          void       SelectErrBar(const char* erbx=NULL, const char* erby=NULL, const char* erbz=NULL);

       
protected:
  NTuple* mNT;
  bool mAdDO;
  int xK, yK, zK;           // Index du nom de variable en X/Y/Z ds le ntuple
  int xebK, yebK, zebK;     // Index du nom de variable en ErrBarX/Y/Z ds le ntuple

};

#endif




