// This may look like C code, but it is really -*- C++ -*-
// Standard Image App      R. Ansari  97-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PISTIMGAPP_H_SEEN
#define PISTIMGAPP_H_SEEN

#include <string.h>
#include <string>
#include <map>

#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 

#include PISTDWDG_H 

#include PIFILECHO_H 
#include "picons.h"

#include "piimage.h"
#include "pi3ddrw.h"
#include "nobjmgr.h"
#include "piacmd.h"
#include "pisiadw.h"
#include "pistzwin.h"


enum {Disp_Next=0, Disp_Win=1, Disp_Same=2, Disp_Stack=3};

typedef map<long, PIWindow*, less<long> > WindMList;
typedef map<long, PIBaseWdg*, less<long> > BWMList;
typedef map<long, PIDrawer*, less<long> > DrwMList;

class PIStdImgApp : public PIApplication  {
public:
     PIStdImgApp(int narg=0, char* arg[]=NULL);
     ~PIStdImgApp();

     virtual void   Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

     int  DispImage(P2DArrayAdapter* nouv, string const & name, int opt);
     int  DispScDrawer(PIDrawer* scd, string const & name, int opt, string title="", bool h2d=false);
     int  Disp3DDrawer(PIDrawer3D* scd, string const & name, int opt, string title="");

     void CreateGraphWin(int nx=1, int ny=1, int sx=0, int sy = 0);
     void CreateStackWin(int sx=0, int sy = 0);
     PIWindow * GetWindow(int typ, int& sx, int& sy, int& px, int& py, int& flag, char * nom);
     void SetZone(int nzx=1, int nzy=1);
     void StackWinNext();

     void DeleteWindow(PIWindow* w);
     void DeleteBaseWidget(PIBaseWdg* w, bool dw=true, bool dwin=true);
     void DelWRsId(int k);
     void CloseAllWindows();

     inline NamedObjMgr* ObjMgr() { return mObjMgr; }
     inline PIACmd* CmdInterpreter() { return mCmd; }

     PIWindow* CurrentWindow() { return (mCurWin); };
     PIBaseWdg* CurrentBaseWdg() { return (mCurWdg); };

     inline PIPixmap* ZoomW() { return zoom; }
     inline PIPixmap* GloVW() { return gimv; }
     inline PICMapView* CMapVW() { return cmapv; }
     inline PIConsole* GetConsole() { return mCons; }

//     inline CutTools*  CutTC()  { return mCutTC; }   A reactiver plus tard ?  Reza 08/98

     inline ObjMgrWind* ObjMgrW() { return mObjmgrw; }
     inline PPInMgrWind* PPInMgrW() { return mPpinmgrw; }

// Redirection ou Non de StdOut/StdErr
     void  RedirectStdOutErr(bool fg = true);
// Gestion des signaux
     void  CatchSignals(bool fg = true);

//  Gestion d attributs graphiques courants
     void  SetColAtt(PIColors fg=PI_NotDefColor, 
                     PIColors bg=PI_NotDefColor);
     void  SetLineAtt(PILineAtt lat=PI_NotDefLineAtt);
     void  SetFontAtt(PIFontSize fsz=PI_NotDefFontSize,
                      PIFontAtt fat=PI_NotDefFontAtt);
     void  SetMarkerAtt(int sz=-1, PIMarker mrk=PI_NotDefMarker);
     void  SetColMapId(CMapId cid=CMAP_OTHER);
     void  SetZoomAtt(int zoom=0);
// Pour sauvegarder-restauration de  l'etat des attributs graphiques
     void  SaveGraphicAtt();   
     void  RestoreGraphicAtt();   

// Gestion fichiers PS
    int num_eps;
    PSFile *mpsfile;
    string name_ps;

// Gestion OUT-PPF
    POutPersist* mPpfout;
    string name_outppf;    

private:
    void MBProcess1(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess2(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess3(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess4(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess5(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess6(PIMessage msg, PIMsgHandler* sender, void* data=NULL);


    NamedObjMgr* mObjMgr;
    PIACmd* mCmd;

    PIMenu* m[6];
    PIMenu* mc;

    PIPixmap* zoom;
    PIPixmap* gimv;
    PICMapView* cmapv;

    PIFileChooser * pfc;

//    CutTools* mCutTC;               // mTCId = 3   A reactiver plus tard ?  Reza 08/98
//    PIContainer* mTC;   A reactiver plus tard ?  Reza 08/98 

    PIConsole* mCons;

    WindMList mWList;
    BWMList mBWList;
    DrwMList mDrwList;

    int mWId,mDId,mBWId;

    PIBaseWdg* mCurWdg;
    PIBaseWdg* mLastWdg;
    PIWindow* mCurWin;
    PIZoneWindow* mGrW;
    PIStackWindow* mStW;
    int mGrIdx;
    int mStIdx;

    ObjMgrWind* mObjmgrw;
    PPInMgrWind* mPpinmgrw;

//  Gestion d attributs graphiques courants, etat sauvegarde
    PIColors     mFCol, mBCol, mSFCol, mSBCol;
    PILineAtt    mLAtt, mSLAtt;
    PIFontSize   mFSz, mSFSz;
    PIFontAtt    mFAtt, mSFAtt;
    int          mMSz, mSMSz;
    PIMarker     mMrk,mSMrk;  
    CMapId       mCmapid, mSCmapid;
    int 	 mZoom, mSZoom;

    PIMessage mFCMsg;  // Message for processing FileOpen
    int mFgScSz;   // Dlag ScreenSize
    bool mFgCWImg; // true -> Current Widget is PIImage
};

#endif
