// This may look like C code, but it is really -*- C++ -*-
#ifndef TOISEGMENT_H
#define TOISEGMENT_H

#include "toi.h"

// ------------ TOISegmented ------------------------------
// Classe de TOI pour echantillonage regulier, avec buffer 
// segmente pour optimiser le multithread et limiter les
// verrous.
// Il faut que les fournisseurs fassent arriver les donnees
// par samplenum croissant et continu.
// --------------------------------------------------------

class TOISegmented : public TOIRegular {
 public:
  TOISegmented();
  TOISegmented(string nm);
  ~TOISegmented();

  
 protected:
  class BufferSegment {
  public:
    BufferSegment(int sz);
    ~BufferSegment();
    static const int NEW = 0;
    static const int WRITE = 1;
    static const int COMMITTED = 2;
    
    int getStatus() {return status;}


    void putData(int sn, double data, uint_8 flag);
    inline double getData(int sn);
    inline uint_8 getFlag(int sn);
    
  private:
    void checkCommitted() {
      if (status != COMMITTED) 
	throw(ForbiddenError("TOISegment: Read on not committed buffer segment"));
    }

    void checkInRange(int sn) {
      if (sn < sn0 || sn >= sn+bufferSize)
	throw(RangeCheckError("TOISegment: out of range access in buffer segment"));
    }


    int status;      // NEW, WRITE, COMMITTED
    int bufferSize;  
    int sn0;         // Samplenum du premier echantillon

    int refcount;    // Nombre de vues qui utilisent 
    pthread_mutex_t refcount_mutex;

    double* data;
    uint_8* flags;
  };
  
  // Master view, gere le lock...
  class MasterView {
  public:
    MasterView();
    ~MasterView();

  protected:
    int s0;
    
    pthread_mutex_t  mutex; // lock for master buffer list access
    pthread_cond_t   condv; // waiting for new buffer
  };


  // per-thread read-only view of a buffer set
  class BufferView {
  public:
    
    void sync();
  protected:
    MasterView master;
  };  
};

// Inline methods

double TOISegmented::BufferSegment::getData(int sn) {
  checkCommitted();
  checkInRange(sn);
  return data[sn-sn0];
}

uint_8 TOISegmented::BufferSegment::getFlag(int sn) {
  checkCommitted();
  checkInRange(sn);
  return flags[sn-sn0];
}

#endif
