#include "toimanager.h"
#include <limits.h>
#include <pthread.h>
#include <iostream.h>

#ifndef MAXINT
#define MAXINT 2147483647
#endif

TOIManager::TOIManager() {
  reqBegin = 0;
  reqEnd = MAXINT;
}

TOIManager* TOIManager::instance = NULL;

TOIManager* TOIManager::getManager() {
  if (instance == NULL) instance =  new TOIManager();
  return instance;
}

void TOIManager::setRequestedSample(int begin, int end) {
  reqBegin = begin;
  reqEnd   = end;
}

int TOIManager::getRequestedBegin() {
  return reqBegin;
}

int TOIManager::getRequestedEnd() {
  return reqEnd;
}

void TOIManager::addThread(pthread_t* t) {
  //  cout << "adding thread  "  <<  t << endl;
  threads.push_back(t); 
}

void TOIManager::joinAll() {
  for (vector<pthread_t*>::iterator i = threads.begin();
       i != threads.end(); i++) {
    pthread_t* pth = *i;
    cout << "joining thread  " << pth <<  endl;
    pthread_join(*pth, NULL);
    cout << "thread joined " << pth << endl;
  }
}
