#include "fitstoiwtr.h"
#include "toimanager.h"



extern void fits_lock();
extern void fits_unlock();

FITSTOIWriter::FITSTOIWriter(string fn) {
  fname = fn;
  fstatus = 0;
  nCols = 1;

  // Open file
  remove(fname.c_str()); 
  fits_lock();
  fits_create_file(&fptr,fname.c_str(),&fstatus);
  fits_unlock();
  name = "wtr";

  totnscount = 0;
}

FITSTOIWriter::~FITSTOIWriter() {
}


void FITSTOIWriter::addInput(string name, TOI* toi, bool withFlag) {
  declareInput(name);
  int iTOI = fwinputs.size();
  fwinputs.push_back(toi);
  colsinput[iTOI] = pair<int,bool>(nCols, withFlag);
  nCols++;
  if (withFlag) nCols++;
  toi->addConsumer(this);
}

void FITSTOIWriter::afterinit()
{
  if (inTOIs) delete[] inTOIs;
  inTOIs = new (TOI*[fwinputs.size()]);

  for (int i=0; i<fwinputs.size(); i++) {
    inTOIs[i] = fwinputs[i];
  }
  
}

void FITSTOIWriter::run() {
  cout << "fitstoiwriter running" << endl;
  // init done here
  afterinit();
  inited=true;

  int ndata = inIx.size();
  //int ncols = inIx.size() * (outFlags ? 2 : 1) + 1;

  char** colnames = new (char*[nCols]);
  char** coltypes = new (char*[nCols]);
  char** colunits = new (char*[nCols]);

  colnames[0] = "sampleNum";
  coltypes[0] = "1D";
  colunits[0] = "integer";

  cout << " FITSTOIWriter::run() - Creating output FITS file: "
       << fname << endl;

  string * coln = new string[nCols];
  for (map<string, int>::iterator ii = inIx.begin(); ii != inIx.end(); ii++) {
    int jTOI = (*ii).second;
    pair<int,bool> p = colsinput[jTOI];
    int ck = p.first;
    coln[ck] = (*ii).first;
    colnames[ck] = const_cast<char*>(coln[ck].c_str());  
    cout << " Column[" << ck << "] Name=" << coln[ck] << endl;
    coltypes[ck] = "1D";
    colunits[ck] = "double";
    if (p.second) {
      ck++;
      coln[ck] = "fg_" + coln[ck-1]; 
      colnames[ck] = const_cast<char*>(coln[ck].c_str());  
      cout << " Column[" << ck << "] -Flag- Name=" << coln[ck] << endl;
      coltypes[ck] = "1J";
      colunits[ck] = "UInt_8Flag";
    }
  }

  fits_lock();
  fits_create_tbl(fptr, BINARY_TBL, 0, nCols, colnames, coltypes, colunits, NULL, &fstatus);
  fits_write_date(fptr, &fstatus);
  fits_unlock();

  delete[] colunits;
  delete[] coltypes;
  delete[] colnames;
  delete[] coln;

  // Add headers ?

  // loop

  int fitsLine = 1;
  int snb = getMinIn();
  int sne = getMaxIn();

  double* tabdata = new double[ndata];
  uint_8* tabflag = new uint_8[ndata]; 
  long* tabflagl = (long*) tabflag; // il faut uint_8 == long, 
                                    // c'est long long dans sophya
  bool* tabck = new bool[ndata];
  int i;
  for(i=0; i<ndata; i++) {
    tabdata[i] = -9.e19;  // $CHECK$ - Reza valeur par defaut !
    tabflag[i] = 0;       // $CHECK$ - Reza valeur par defaut !
    tabck[i] = checkInputTOIIndex(i);
  } 

  for (int sn = snb; sn <= sne; sn++) {
    //    if ((sn%2000 == 0) || (sn<snb+5)) 
    //  cout << " DBG-A-FitsWriter::run()" << sn << endl;
    try {
      uint_8 out_flg;
      double out_val;
      for (i=0; i<ndata; i++) {
	if (tabck[i]) {
	  getData(i,sn, out_val, out_flg);
	  tabdata[i] = out_val;
	  tabflag[i] = out_flg & 0xFFFFFFFF;
	}
      }
      wontNeedBefore(sn);
      fits_lock();
      //      if ((sn%2000 == 0) || (sn<snb+5)) 
      //cout << " DBG-B-FitsWriter::run()" << sn << endl;
      double xx = sn;
      fits_write_col_dbl(fptr, 1, fitsLine, 1, 1, &xx, &fstatus);
      
      for (i=0; i<ndata; i++) {
	pair<int,bool> p = colsinput[i];
	fits_write_col_dbl(fptr, p.first+1, fitsLine, 1, 1, tabdata+i, &fstatus);
	if (p.second) {
	  fits_write_col_lng(fptr, p.first+2, fitsLine, 1, 1, tabflagl+i, &fstatus);
	} 
	if (fstatus != 0) {
	  cerr << "fitstoiwtr error sn = " << sn << " i = "<< i << endl;
	  fits_report_error(stderr, fstatus);
	  abort();
	}
      }
      fits_unlock();
      //           if ((sn%2000 == 0) || (sn<snb+5)) 
      //      	cout << " DBG-C-FitsWriter::run()" << sn << " line=" << fitsLine << endl;
      fitsLine++;  totnscount++;
    } catch (PException e) {
    cout << "fitstoiwtr exception " << e.Msg() << endl;
    continue;
    }
  }

  delete[] tabdata;
  delete[] tabflag;
  delete[] tabck;

  fits_lock();
  fits_close_file(fptr, &fstatus);
  fits_report_error(stderr, fstatus);
  fits_unlock();
  cout << "fitstoiwriter done fitsLine= " << fitsLine << endl;
}








