#include "toi.h"
#include "toisegment.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toisqfilter.h"
#include "toimanager.h"

int main(int argc, char** argv) {
  cout << "tsttoi starting" << endl;
  TOIManager* mgr = TOIManager::getManager();
  mgr->setRequestedSample(104000000,104020000);

  FITSTOIReader r1(argv[1]);
  FITSTOIReader r2(argv[2]);

  FITSTOIWriter w1("out1.fits");
  FITSTOIWriter w2("out2.fits");

  
  TOI* toi1 = new TOISegmented(1024);
  r1.addOutput("boloMuV_8", toi1);

  TOI* toi2 = new TOISegmented(1024);
  r2.addOutput("boloMuV_11", toi2);
  
  w1.addInput("143K01", toi1);
  w1.addInput("143K02", toi2);

  w2.addInput("143K01", toi1);
  w2.addInput("143K02", toi2);
  
  cout << "starting" << endl;

  r1.start();
  r2.start();
  w1.start();
  w2.start();

  cout << "joining" << endl;
  mgr->joinAll();
  return(0);
}
