// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive      PIWdgGen
//                                    Reza 10/95            
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIWDG_H_SEEN
#define PIWDG_H_SEEN

#include "pimsghandler.h"

#include <string>
#include <list>
#if defined(__KCC__)
using std::string ;
#include <list.h>
#endif


void PIBeep();

// Les differents types d accrochage aux containers  

enum PIBindingKind {    
  PIBK_free = 0,
  PIBK_fixed = 1,
  PIBK_elastic = 2
};

enum PICopyPasteKind {    // Pour gerer les types d objets echange en copier/coller
  PICP_string = 1
};

class PSFile;
class PIContainerGen;
class PIEventHandler;

class PIWdgGen : public PIMsgHandler
{
public:
  enum {ClassId = 100};

                         PIWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual               ~PIWdgGen();
  virtual void		 FinishCreate()=0; // apres avoir installe les sous-vues

  virtual long           kind() {return ClassId; }
//  string               kindstr();

  inline PIContainerGen* Parent() { return( parent ); }

  inline void         	 SetUserData( void * p, int fg = 0) {pdata=p; flag=fg; }
  inline void*       	 UserData() { return (pdata); };
  inline void const* 	 UserData() const { return (pdata); };
  inline int         	 UserFlag() { return(flag); };


  virtual void           SetMsg(PIMessage msg = 0);
  inline  PIMessage      Msg() { return (myMsg); }

  virtual void           SetSize(int sx, int sy)=0;
  virtual void           SetPos(int px, int py)=0;
  virtual void           SetBorderWidth(int bw)=0;
  virtual void           SetLabel(string const&) {}
  virtual void           SetBinding(PIBindingKind left, PIBindingKind top, 
                                    PIBindingKind right, PIBindingKind bottom)=0;

  virtual int            XSize()=0;
  virtual int            YSize()=0;
  virtual int            XPos()=0;
  virtual int            YPos()=0;

  virtual string         Nom()=0;
  virtual void           GetScreenPos(int & spx, int & spy);

// Pour activer, desactiver un composant graphique (PIWdg)
  virtual void           Manage()=0;
  virtual void           UnManage()=0;
  virtual bool           IfManaged()=0;
  virtual bool           IsVisible()=0;

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
//  aux actions utilisateur (souris, clavier, ...)
  virtual void           SetSensitive()=0;
  virtual void           SetUnSensitive()=0;
  virtual bool           IfSensitive()=0;

  virtual void           PSPrint(PSFile *psf, int ofx=0, int ofy=0);

//  Gestion de copier-coller
  virtual bool           ClaimSelection(unsigned int typ=PICP_string)                     = 0;
  virtual void           SelectionLost()                                                  = 0;
  virtual unsigned int   RequestSelection(unsigned int typ=PICP_string)                   = 0;
  virtual void*          ProvideSelection(unsigned int& typ, unsigned int& len)           = 0;
  virtual void           SelectionTransferEnd()                                           = 0;
  virtual void           PasteSelection(unsigned int typ, void *pdata, unsigned int l)    = 0;

//  Gestion des EventHandler
  virtual void		 AddDrawHandler(PIEventHandler* drwh, bool ad=false);
  virtual void		 RemoveDrawHandler(PIEventHandler* drwh);
  virtual void		 AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false);
  virtual void		 RemoveEventHandler(PIEventHandler* evh);

// !! Devrait etre protected - mis ici a cause de cxx  Reza 12/98
  struct EvHand { PIEventHandler* evh; unsigned long mask;  bool ad; };
protected:
  PIContainerGen*        parent;
  PIMessage              myMsg;
  list<EvHand>		 mDHlist;
  list<EvHand>		 mEHlist;
private:
  int flag;
  void * pdata;
};


  

#endif/* PIWDG_H_SEEN */
