// This may look like C code, but it is really -*- C++ -*-

#ifndef FITSTOIRDR_H
#define FITSTOIRDR_H

#include "toiprocessor.h"
#include <string>
#include <vector>
#include <map>
#include "fitsio.h"


class FITSTOIReader : public TOIProcessor {
public:
  FITSTOIReader(string fn,int buff_sz=1000);
  ~FITSTOIReader();

  virtual void addFile(string fn);

  virtual void init();  
  virtual void run(); 
 
  inline int_8	ProcessedSampleCount() const { return totnscount; }

protected:
  virtual int   calcMinOut();
  virtual int   calcMaxOut();

  virtual void run1();
  virtual void run2();
  virtual void openFile(string fn);

private:
  fitsfile* fptr;
  int       fstatus;
  string    fname;   // current file
  long      nrows;   // current file
  int       firstSn; // current file
  int       Buff_Sz; // buffer size

  int       ncols;   // including flags. getNOut() is # of tois.
  int       snBegin; // first file
  int       snEnd;   // last file
  
  vector<string> allfn;
  map<int,pair<int, bool> > colsinput; // iTOI -> (colonne, hasflag)
  // le flag est alors en colonne+1

  int_8 totnscount;   // Nombre total d'echantillon processe

};

#endif
