#!/bin/csh
# Placez vous dans le repertoire ou vous avez
# mis le NOUVEAU code du libastro de Xephem.

set dir = $DPCSOURCE/XephemAstroLib/
set log = `pwd`/compare.log

rm -f $log; touch $log

echo ======================= NOUVEAU REPERTOIRE >>& $log
ls *.h >>& $log
ls *.c >>& $log

echo ======================= REPERTOIRE $dir >>& $log
pushd $dir
ls *.h  >>& $log
ls *.c >>& $log
popd

echo ======================= INCLUDE >>& $log
foreach f ( *.h )
  echo ======================= $f >>& $log
  diff $f $dir/$f >>& $log
end

echo ======================= FICHIERS >>& $log
foreach f ( *.c )
  echo ======================= $f >>& $log
  diff $f $dir/$f >>& $log
end

exit 0
