#include <stdexcept>
#include <unistd.h>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "toisegment.h"
#include "sophyainit.h"
#include "ktoibad.h"

void usage(void);
void usage(void) {
 cout<<"tstktoibad [-h] [options] fits_in fits_out"
 <<" -s sdeb,sfin"
 <<" -b label_bolomuv"
 <<" -g lg,lm,nsg,bupd"
 <<" -a lmaround"
 <<" -p lp,sn1,sn2"
 <<endl;
}

int main(int narg, char** arg)
{
 int_4 sdeb=0,sfin=-1;
 int_4 lp=1,sn1=-1,sn2=-1;
 uint_4 lg=3,lm=15,bupd=1000,lmaround=10;
 r_8 nsg=5.;
 char *label_bolomuv = "boloMuV";
  int c;
 while((c = getopt(narg,arg,"hs:g:b:a:p:")) != -1) {
  switch (c) {
  case 's' :
   sscanf(optarg,"%d,%d",&sdeb,&sfin);
   break;
  case 'g' :
   sscanf(optarg,"%d,%d,%lf,%d",&lg,&lm,&nsg,&bupd);
   break;
  case 'a' :
   sscanf(optarg,"%d",&lmaround);
   break;
  case 'b' :
    label_bolomuv = optarg;
    break;
  case 'p' :
   sscanf(optarg,"%d,%d,%d",&lp,&sn1,&sn2);
   break;
  case 'h' :
  default:
   usage(); exit(1);
  }
 }
 if(optind+1>=narg) {usage(); exit(2);}
 char * fitsin  = arg[optind];
 char * fitsout = arg[optind+1];

 SophyaInit();
 TOIManager* mgr = TOIManager::getManager();
 if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);

 //--------------------------------------------------------------------
 try {
 //--------------------------------------------------------------------

 // FITS reader
 FITSTOIReader rfits(fitsin);
 cout<<"Lecteur: created"<<endl;

 // FITS writter
 FITSTOIWriter wfits(fitsout);
 cout<<"Ecriveur: created"<<endl;

 // TOI processeurs
 FlagGlitch deglitch(lg,lm,nsg);
 deglitch.SetBuffUpd(bupd);
 deglitch.SetDebug(lp,sn1,sn2);
 deglitch.Print();

 FlagAround flgaround(lm);
 flgaround.Print();

 // Creation des tuyaux et des connections associees
 int taille = 8192;
 // tuyau bolo pour entree processeur FlagGlitch
 TOISegmented * toi1 = new TOISegmented("tuyau_bolo_in1",taille);
 rfits.addOutput(label_bolomuv,toi1);
 deglitch.addInput("BoloIn",toi1);

 // tuyau bolo pour entree processeur FlagAround
 TOISegmented * toi2 = new TOISegmented("tuyau_bolo_in2",taille);
 deglitch.addOutput("BoloOut",toi2);
 flgaround.addInput("BoloIn",toi2);

 // tuyau bolo pour entree fits writer
 TOISegmented * toiout = new TOISegmented("tuyau_bolo_out",taille);
 flgaround.addOutput("BoloOut",toiout);
 wfits.addInput(label_bolomuv,toiout,true);

 // Print de status avant lancement des taches:
 cout<<"----- FITSReaderTOI::PrintStatus() 1 : -----"<<endl;
 rfits.PrintStatus(cout);
 cout<<"----- FITSWriterTOI::PrintStatus() : -----"<<endl;
 wfits.PrintStatus(cout);  
 cout<<"----- TOISegmented::PrintStatus() : -----"<<endl;
 toi1->PrintStatus(cout);  
 toi2->PrintStatus(cout);  
 toiout->PrintStatus(cout);  
 cout<<"-----FlagGlitch ::PrintStatus() : -----"<<endl;
 deglitch.PrintStatus(cout);  
 cout<<"-----FlagAround ::PrintStatus() : -----"<<endl;
 flgaround.PrintStatus(cout);  

 // Lancement des taches

 rfits.start();
 wfits.start();
 deglitch.start();
 flgaround.start();  

 // Gestion de la re-connection des threads
 mgr->joinAll();
 cout<<"End threads"<<endl;

 //--------------------------------------------------------------------
 // Que fait on avec les exceptions qui ont ete lancees ?
 } catch (PThrowable & exc) {    // Sophya exceptions
  cout<<"\ntstktoibad: Catched Exception \n"<<(string)typeid(exc).name() 
      <<" - Msg= "<<exc.Msg()<<endl;
 } catch (const std::exception & sex) {    // Standard exceptions
  cout<<"\ntstktoibad: Catched std::exception \n" 
      <<(string)typeid(sex).name()<<endl; 
 } catch (...) {    // Other exceptions
  cout<<"\ntstktoibad: some other exception was caught ! "<<endl;
 }
 //--------------------------------------------------------------------

 return(0);
}
