// This may look like C code, but it is really -*- C++ -*-
#ifndef TOI2MAP_H
#define TOI2MAP_H

#include "toiprocessor.h"
#include "flagtoidef.h"
#include "slinparbuff.h"

//-- Pour rechercher les glitches
//   toi BoloIn ---> |FlagGlitch | ---> toi BoloOut
class FlagGlitch : public TOIProcessor {
public:
  FlagGlitch(uint_4 lg,uint_4 lm,r_8 nsg);
  virtual ~FlagGlitch();

  virtual void	init(void);
  virtual void	run(void);

  //! Ne pas traiter les sample deja flaggues par la valeur flag
  inline void DoNotLookAt(uint_8 flag=0) {flgNotLookAt = flag;}
  //! Flagguer les glitches avec la valeur flag
  inline void SetFlag(uint_8 flag=FlgToiSpike) {flgGlitch = flag;}
  //! Frequency to update SLinParBuff buffer
  void SetBuffUpd(uint_4 bupd=1000) {BuffUpdate = bupd;}
  //! Print
  void Print(ostream & os);
  inline void Print(void) {Print(cout);}
  //! Debugging print lp=ab
  //    a>0 ntuple entre snb,sne
  //    b>0 print general
  //     >1 print debug entre snb,sne
  inline void SetDebug(int_4 lp,int_4 snb,int_4 sne)
              {mLP=(lp>=0)?lp:0; mLPsnb=snb; mLPsne=sne;}

protected:
  int_4 mLP,mLPsnb,mLPsne;
  uint_8 flgNotLookAt,flgGlitch;
  r_8 NSCut;
  uint_4 BuffUpdate;
  uint_4 LGlitch,LSide;
  SLinParBuff* Slpb[2];
};

//-- Pour flagguer les samples autour de samples deja flaggues
//   toi BoloIn ---> |FlagAround | ---> toi BoloOut
class FlagAround : public TOIProcessor {
public:
  FlagAround(uint_4 lm,uint_8 flgs=FlgToiAll);
  virtual ~FlagAround();

  virtual void	init(void);
  virtual void	run(void);

  //! Flagguer les samples avec la valeur flag
  inline void SetFlag(uint_8 flag=FlgToiAround) {flgAround = flag;}
  //! Flagguer autour des samples ayant la valeur flag
  inline void SetFlagAroundFlag(uint_8 flag=FlgToiAll) {flgSample = flag;}
  //! Print
  void Print(ostream & os);
  inline void Print(void) {Print(cout);}

protected:
  uint_8 flgSample,flgAround;
  uint_4 LSide;
};

#endif
