// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toiregwindow.h,v 1.3 2001-11-08 15:47:46 aubourg Exp $

#ifndef TOI_REGWINDOW_H
#define TOI_REGWINDOW_H

#include "config.h"

#include <pthread.h>
#include <vector>
using namespace std;
#include "toi.h"

// Classe de TOI avec une fenetre glissante, et echantillonnage regulier.
// Pour le moment au moins,
// il faut que les providers fassent arriver les donnees par samplenum croissant.
class TOIRegularWindow : public TOIRegular {
public:
  TOIRegularWindow();
  TOIRegularWindow(string nm);
  virtual ~TOIRegularWindow();

  virtual DataStatus isDataAvailNL(int iStart, int iEnd);
  virtual DataStatus isDataAvailNL(int i); // override required


//protected:
  vector<double> data;
  vector<long>  flags;
  long          i0;
  double defaultValue;
 
#ifdef WITH_SOPHYA
  /* l'interface va etre modifiee, NE PAS UTILISER
  virtual Array         doGetData(int iStart, int iEnd);
  virtual TArray<int_4> doGetFlag(int iStart, int iEnd);
  l'interface va etre modifiee, NE PAS UTILISER */
#endif
  virtual void          doGetData(int i, double & val, uint_8 & flg);
   
  virtual void          doPutData(int i, double value, uint_8 flag=0);
  virtual void          doWontNeedBefore(int i);

  virtual int           nextDataAvail(int iAfter);
  virtual bool          hasSomeData();
};

#endif
