// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi.cc,v 1.7 2001-11-08 15:47:46 aubourg Exp $

#include "toiprocessor.h"
#include "toi.h"
#include <pthread.h>

#ifdef WITH_SOPHYA
#include "pexceptions.h"
#else
#include "apexceptions.h"
#endif


TOI::TOI() {
  TOIInit();
}

TOI::TOI(string n) {
  name = n;
  TOIInit();
}

void TOI::TOIInit() {
  pthread_mutex_init(&mutex, NULL);
  //   ----- Rajouts Reza 12/3/2001
  pthread_cond_init(&condv, NULL);
  fgwaitput = fgwaitget = false;
  fgsigput = fgsigget = false;
  countwaitput = countwaitget = 0;
  //  Fin rajouts Reza 12/3/2001 ------
//  pthread_mutex_setname_np(&mutex, (name + "_toi_mutex").c_str(), 0);
  defaultValue = 0;
  producer = NULL;
  dbg = false;
}

TOI::~TOI() {
  pthread_mutex_destroy(&mutex);
}

void TOI::PrintStatus(ostream & os) const
{
  os << "TOI::PrintStatus() - Name=" << getName() << endl;
  os << " WaitStatus: Put/" ;
  if (isPutWaiting()) os << "Waiting " ;
  else os << "Running ";
  os << " PutCountWait= " << getCountWaitPut() << endl;
  os << " WaitStatus: Get/" ;
  if (isGetWaiting()) os << "Waiting " ;
  else os << "Running ";
  os << " GetCountWait= " << getCountWaitGet() << endl;
}


void TOI::setProducer(TOIProcessor* p) {
  if (producer) 
    throw DuplicateIdExc("TOI::setProducer : producer already defined");
  producer = p;
}

void TOI::addConsumer(TOIProcessor* p) {
  consumers.push_back(p);
}

int TOI::getMinSn(){
  return producer->getMinOut();
}

int TOI::getMaxSn(){
  return producer->getMaxOut();
}

/* 
 RZCMV   ----- l'interface va etre modifiee, NE PAS UTILISER
#ifndef NO_SOPHYA 
Array TOI::getError(int iStart, int iEnd) {
  if (errorTOI == NULL) throw NotFoundExc("TOI::getDataError : no Error TOI");
  return errorTOI->getData(iStart, iEnd); 
}
Array TOI::getData(int iStart, int iEnd) {
  lock();
  Array a = doGetData(iStart, iEnd);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return a;
}
TArray<int_4> TOI::getFlag(int iStart, int iEnd) {
  lock();
  TArray<int_4> a = doGetFlag(iStart, iEnd);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return a;
}
#endif
  l'interface va etre modifiee, NE PAS UTILISER ---- 
*/


/* 
RZCMV  -------   A revoir les getError() ...
double TOI::getError(int i) {
  if (errorTOI == NULL) throw NotFoundExc("TOI::getDataError : no Error TOI");
  return errorTOI->getData(i);
}

void TOI::putDataError(int i, double value, double error, int_4 flag) {
  if (errorTOI == NULL) throw NotFoundExc("TOI::getDataError : no Error TOI");
  putData(i, value, flag);
  errorTOI->putData(i, value, flag);
}

*/

double TOI::getData(int i) {
  lock();
  uint_8 flg;
  double dat;
  doGetData(i, dat, flg);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return dat;
}

void TOI::getData(int i, double &data, uint_8 &flag) {
  lock();
  doGetData(i, data, flag);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return;
}

  

void TOI::putData(int i, double value, uint_8 flag) {
  lock();
  doPutData(i, value, flag);
  unlock();
  if (fgsigget) { fgsigget = false; broadcast(); }
}

void TOI::waitForData(int iStart, int iEnd) {
  if (producer == NULL) throw NotFoundExc("TOI has no producer !");
    
  DataStatus s = isDataAvail(iStart, iEnd);
  if (s == DATA_OK) {
      return;
  }
  if (s == DATA_DELETED) {
      throw NotFoundExc("Data has been purged !");
  }

  producer->lock();
  while (isDataAvailNL(iStart, iEnd) == DATA_NOT_YET) {
    producer->wait();
  }
  producer->unlock();
  return;
}

void TOI::waitForData(int i) {
  waitForData(i,i);
}

void TOI::waitForAnyData() {
  if (! hasSomeData()) {
    producer->lock();
    producer->wait();
    producer->unlock();
  }
}

TOI::DataStatus TOI::isDataAvail(int i) {
  lock();
  DataStatus stat = isDataAvailNL(i);
  unlock();
  return stat;
}

TOI::DataStatus TOI::isDataAvail(int i, int j) {
  lock();
  DataStatus stat = isDataAvailNL(i,j);
  unlock();
  return stat;
}

TOI::DataStatus TOI::isDataAvailNL(int i) {
  return isDataAvailNL(i,i);
}

void TOI::wontNeedBefore(int i) {
  int j=i;
  for (vector<TOIProcessor*>::iterator k = consumers.begin();
       k != consumers.end(); k++) {
    if ((*k)->wontNeedValue < j) j = (*k)->wontNeedValue;
  }
  lock();
  doWontNeedBefore(j);
  unlock();
}

void TOI::doWontNeedBefore(int i) {
}


