// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: rztoi.h,v 1.3 2001-11-08 15:47:45 aubourg Exp $


#ifndef RZTOIPROC_H
#define RZTOIPROC_H

#include "toiprocessor.h"

class RzTOIProc : public TOIProcessor {
public:
  RzTOIProc(int w1=4096, int w2=128, int nmax=20);
  inline void setOutPPF(string const & ppfname) 
              { outppf = ppfname; }
  virtual void init();  
  virtual void run();

protected:
  int _width1;
  int _width2;
  int _nmax;
  string outppf;
};

class RzSimpleTOIProc : public TOIProcessor {
public:
  RzSimpleTOIProc(int wsz=1024, double fact=1.0);
  virtual void init();  
  virtual void run();

protected:
  double _fact;
  int _wsz;
};

#endif
