// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: map2toi.h,v 1.5 2001-11-13 16:14:43 aubourg Exp $

#ifndef MAP2TOI_H
#define MAP2TOI_H

#include "toiprocessor.h"
#include "spherehealpix.h"
#include "flagtoidef.h"
#include "xastropack.h"

//-- Un generateur de TOI a partir d'une sphere et de 2 TOIs coordin1,coordin2
// Lecture de 2 TOI coord1,coord2 et d'une Sphere Healpix
// Sortie de 3 TOI coord1,coord2,boloMuV
//
// Structure generale :
//             Sphere ---- |
//                         |
//                     -----------
//   toi CoordIn1 ---> |         | ---> toi CoordOut1
//                     | Map2TOI | ---> toi CoordOut2
//   toi CoordIn2 ---> |         | ---> toi BoloOut
//                     -----------
// Gestion du type de coordonnees :
// Coord1In,Coord2In : soit Equatoriales (Alpha,Delta)
//                     soit Galactiques  (GLong,GLat)
// La sphere peut avoir des coordonnees differentes des CoordIn
// Si les CoordIn et les CoordSphere sont equatoriales -> meme equinoxe!
// La sortie CoordOut aura les MEMES coordonnees que les CoordIn

class Map2TOI : public TOIProcessor {
public:
                 Map2TOI(SphereHEALPix<r_8>& sph);
  virtual	~Map2TOI();

  virtual void	init(void);
  virtual void	run(void);

  // Pour savoir si on a de HourDeg,DegDeg,RadRad
  inline void SetEquinox(double actualyear=2000.)
              {mActualYear = actualyear;}
  inline void SetCoorIn(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorIn = mfg;}
  inline void SetCoorMap(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorMap = mfg;}
  // Print
  void Print(std::ostream & os);

protected:
  SphereHEALPix<r_8>& mSph;
  TypAstroCoord mTypCoorIn,mTypCoorMap;
  double mActualYear;
};

#endif
