// This may look like C code, but it is really -*- C++ -*-
#ifndef SMOOTHTOI_H
#define SMOOTHTOI_H

#include "toiprocessor.h"
#include "flagtoidef.h"
#include "slinparbuff.h"

//////////////////////////////////////////////////////
//-- Pour flagguer les samples hors dynamique
//   toi BoloIn ---> |FlagOutOfRange| ---> toi BoloOut
//////////////////////////////////////////////////////
class DataSmooth : public TOIProcessor {
public:
  DataSmooth(uint_4 lsm,uint_4 deg);
  virtual ~DataSmooth();

  virtual void	init(void);
  virtual void	run(void);

  //! Ne pas traiter les samples flaggues par la valeur flag
  inline void DoNotLookAt(uint_8 flag=FlgToiAll) {flgNotLookAt = flag;}
  //! Flagguer les valeurs ou le smooth a echoue avec la valeur flag
  inline void SetFlagFailed(uint_8 flag=FlgToiInterp) {flgNotSmoothed = flag;}
  //! Frequency to update SLinParBuff buffer
  inline void SetBuffUpd(uint_4 bupd=100) {BuffUpdate = bupd;}
  //! Nombre minimum de valeurs requises pour smoother un sample
  inline void MinSmoothLength(uint_4 lsmin=0)
              {
              if(lsmin==0) lsmin=LSmooth;
              LSmoothMin = (lsmin<DegSmooth+1)? DegSmooth+1: lsmin;
              }

  //! Print
  void Print(::ostream & os);
  inline void Print(void) {Print(cout);}

protected:
  uint_8 flgNotLookAt,flgNotSmoothed;
  uint_4 LSmooth,LSmoothMin;
  uint_4 DegSmooth;
  uint_4 BuffUpdate;
};

#endif
