#include "machdefs.h"
#include "toimanager.h"
#include "pexceptions.h"
#include "smoothtoi.h"


////////////////////////////////////////////////////////////////////////
// Calcul d'une valeur lissee
// |--lsm--|<sample>|--lsm--|
////////////////////////////////////////////////////////////////////////

DataSmooth::DataSmooth(uint_4 lsm,uint_4 deg)
  : LSmooth(lsm), DegSmooth(deg)
{
 if(DegSmooth>2) DegSmooth=2;
 if(LSmooth<DegSmooth+1) LSmooth = DegSmooth+1;
 DoNotLookAt();
 SetFlagFailed();
 SetBuffUpd();
 MinSmoothLength();
}

DataSmooth::~DataSmooth()
{
}

void DataSmooth::Print(::ostream & os)
{
 os<<"DataSmooth::Print LSmooth="<<LSmooth
   <<" LSmoothMin="<<LSmoothMin
   <<" DegSmooth="<<DegSmooth<<endl
   <<" .... BuffUpdate="<<BuffUpdate
   <<" flgNotLookAt="<<flgNotLookAt
   <<" flgNotSmoothed="<<flgNotSmoothed<<endl;
}

void DataSmooth::init()
{
 cout << "DataSmooth::init" << endl;
 declareInput("DataIn");       // input index 0
 declareOutput("DataSmooth");     // output index 0

 int_4 lbuff = 2*LSmooth +10;
 if(neededHistory<lbuff) setNeededHistory(lbuff);
}

void DataSmooth::run()
{
long snb = getMinIn();
long sne = getMaxIn();

if(snb>sne) {
  cout<<"DataSmooth::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("DataSmooth::run() - Bad sample interval");
}
if(!checkInputTOIIndex(0)) {
  cout<<"DataSmooth::run() - Input TOI (DataIn) not connected! "<<endl;
  throw ParmError("DataSmooth::run() Input TOI (DataIn) not connected!");
}
if(!checkOutputTOIIndex(0)) {
  cout<<"DataSmooth::run() - Output TOI (DataOut) not connected! "<<endl;
  throw ParmError("DataSmooth::run() Output TOI (DataOut) not connected!");
}

//---------------------------------------------------------
try {

 SLinParBuff slb0(LSmooth,BuffUpdate,0.,0.,true);
 SLinParBuff slb1(LSmooth,BuffUpdate,0.,0.,true);
 SLinParBuffMerger slbm;

cout<<"DataSmooth::run(): SampleNum de "<<snb<<" a "<<sne<<endl;
uint_4 notsmoothed=0;

// Initialisation
for(int_4 sn=snb;sn<snb+LSmooth && sn<=sne;sn++) {
  r_8 bolo; uint_8 fgbolo=0;
  getData(0,sn,bolo,fgbolo);
  if(!(fgbolo & flgNotLookAt)) slb1.Push((r_8)sn,bolo);
}

{for(int_4 sn=snb;sn<=sne;sn++) {

  r_8 bolo; uint_8 fgbolo=0;
  getData(0,sn,bolo,fgbolo);

  //    <---lms---><i><---lms--->
  //              |             |
  //             ideb          ifin
  int_4 ideb=sn-1, ifin=sn+LSmooth;

  if(ideb>=snb) {
    r_8 bol; uint_8 fgb=0;
    getData(0,ideb,bol,fgb);
    if(fgb&flgNotLookAt) slb0.Pop();
      else slb0.Push((r_8)ideb,bol);
  }

  if(ifin<=sne) {
    r_8 bol; uint_8 fgb=0;
    getData(0,ifin,bol,fgb);
    if(fgb&flgNotLookAt) slb1.Pop();
      else slb1.Push((r_8)ifin,bol);
  } else slb1.Pop();

  slbm.Reset(); slbm.Add(slb0); slbm.Add(slb1);

  if(slbm.NPoints()>=LSmoothMin) {
    r_8 s=-1.,a0,a1=0.,a2=0.;
    if(DegSmooth==0)      s = slbm.Compute(a0);
    else if(DegSmooth==1) s = slbm.Compute(a0,a1);
    else if(DegSmooth==2) s = slbm.Compute(a0,a1,a2);
    if(s>=0.) {
      bolo -= a0 + (a1 + a2*sn)*sn;
    } else {
      fgbolo |= flgNotSmoothed;
      notsmoothed++;
    }
  } else {
    fgbolo |= flgNotSmoothed;
    notsmoothed++;
  }

  putData(0,sn,bolo,fgbolo);
}}
cout<<"DataSmooth::run(): Fin de boucle: notsmoothed="<<notsmoothed
    <<" / tot="<<sne-snb+1<<endl;

//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"DataSmooth: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;                                                                            
}
