// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitstoiwtr.h,v 1.10 2001-11-14 14:12:32 aubourg Exp $


#ifndef FITSTOIWTR_H
#define FITSTOIWTR_H

#include "toi.h"
#include "toiprocessor.h"
#include <string>
#include <map>
#include "fitsio.h"


class FITSTOIWriter : public TOIProcessor {
public:
  FITSTOIWriter(string fn);
  ~FITSTOIWriter();
  
  virtual void afterinit();

  virtual void  addInput(string name, TOI* toi)
    {addInput(name,toi,false);}
  virtual void  addInput(string name, TOI* toi, bool withFlag);

  virtual void  run(); 
 
  inline int_8	ProcessedSampleCount() const { return totnscount; }
  
private:
  string fname;
  fitsfile *fptr;
  int fstatus;
  vector<TOI*> fwinputs;
  int nCols;
  map<int,pair<int, bool> > colsinput; // iTOI -> (colonne, hasflag)
  // le flag est alors en colonne+1

  int_8 totnscount;   // Nombre total d'echantillon processe
};

#endif
