
// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: flagtoidef.h,v 1.6 2001-11-15 10:42:17 aubourg Exp $

#ifndef FLAGTOIDEF_H
#define FLAGTOIDEF_H

#include "config.h"

enum FlagToiDef {
// Out of Range Value of Range Value
  FlgToiOut     =  (unsigned long long)1 << 0,
// Spike-like sample (ex: glitch)
  FlgToiSpike   =  (unsigned long long)1 << 1,
// Discontinuity-like sample (ex: step)
  FlgToiDisc    =  (unsigned long long)1 << 2,
// Large-Sigma-like sample
  FlgToiSigma   =  (unsigned long long)1 << 3,
// Cleaned sample (ex: clean after spike,step...)
  FlgToiClean   =  (unsigned long long)1 << 4,
// Sample Value has been interpolated/Replaced ...
  FlgToiInterp  =  (unsigned long long)1 << 5,
// Sample killed because near a "flaggued" one ...
  FlgToiAround  =  (unsigned long long)1 << 6,
// All bit to one ...
#ifdef IRIX64
  FlgToiAll     =  (int)~(unsigned long long)0
#else
  FlgToiAll     =  ~(unsigned long long)0
#endif
};

// et on peut continuer ainsi jusqu'a 1<<63 cad le bit 64 ieme
// Pour imprimer la valeur: cout<<(unsigned long long)FlgToi...<<endl;

#endif
