#include "machdefs.h"
#include "array.h"
#include <unistd.h>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toisqfilter.h"
#include "toimanager.h"
#include "rztoi.h"
#include "toiseqbuff.h"
#include "toiregwindow.h"
#include "timing.h"
#include "sambainit.h"
#include <stdexcept>

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " tstrztoi : Argument Error ! tstrztoi -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : tstrztoi [-sproc] [-rwtoi] [-dbg] [-start snb] [-end sne] \n" 
	 << "         [-w1 sz] [-w2 sz] inFitsName outFitsName ppfFileName \n" 
	 << "   -sproc : Run RzSimpleTOIProc (default RzTOIProc) \n"
	 << "   -rwtoi : Use Regular Window TOI (default TOISeqBuffered) \n" 
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -w1 sz : sets main data window size (def= 8192)\n"
	 << "   -w2 sz : sets secondary window size (def= 512) \n"
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "tstrztoi starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgsimple = false;
  bool fgrwtoi = false;
  bool fgdbg = false;
  int w1 = 8192;
  int w2 = 512;
  int nmax = 10;
  int istart = 104121000+w1*5;
  int iend = 0;
  string infile;
  string outfile;
  string ppffile;

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-w1") == 0) {
      if (ia == narg-1) Usage(true);  
      w1 = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-w2") == 0) {
      if (ia == narg-1) Usage(true);  
      w2 = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-sproc") == 0)  fgsimple = true;
    else if (strcmp(arg[ia],"-rwtoi") == 0)  fgrwtoi = true;
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+w1*(nmax+5);
  if ((narg-ko) < 3)  Usage(true); 
  infile = arg[ko];
  outfile = arg[ko+1];
  ppffile = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  InitTim();

  cout << ">>>> tstrztoi: Infile= " << infile << " outFile=" << outfile 
       << " ppfFile= " << ppffile << endl;
  cout << ">>>> Window Size W1= " << w1 << " W2= " << w2
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);

    mgr->setRequestedSample(istart, iend);
  
    //    FITSTOIReader r("/data/Archeops/bolo11.fits); 
    FITSTOIReader r(infile); 
    cout << "reader created" << endl;
    //    FITSTOIWriter w("/data/Archeops/rz.fits");
    FITSTOIWriter w(outfile);
    cout << "fits writer created" << endl;


    char * colname[5] = {"MJD", "UTC","boloMuV_11","magnFlux","pivot"};
    char * toiname[5] = {"MJD", "UTC","bolo11","magneto","pivot"};
    TOI* toitab[5];
    TOI* toi2;
    int kk;
    if (fgrwtoi) {
      cout << " Using TOIRegularWindow TOI's ... " << endl;
      for(kk=0; kk<5; kk++) {
	toitab[kk] = new TOIRegularWindow(toiname[kk]);
      }
      toi2 = new TOIRegularWindow("t2");
    }
    else {
      cout << " Using TOISeqBuffered TOI's ... " << endl;
      for(kk=0; kk<5; kk++) {
	TOISeqBuffered * toisb = new TOISeqBuffered(toiname[kk], w1);
	toitab[kk] = toisb;
	if (fgdbg) toisb->setDebugLevel(1);
      }
      TOISeqBuffered * toisb = new TOISeqBuffered("t2", w1);
      if (fgdbg) toisb->setDebugLevel(1);
      toi2 = toisb;
    }

    // Connecting TOI to FITSTOIReader Processor
    //    for(kk=0; kk<5; kk++) {
    //      r.addOutput(colname[kk], toitab[kk]);
    //    }

    kk = 2;
    TOI* toi = toitab[kk];
    r.addOutput(colname[kk], toi);
    //  toi->dbg=true;
    //  r.addOutput("boloMuV_11", toi);
    cout << " connecting in/out to RzTOIProcessor ... " << endl;

    //    TOIProcessor * filt = NULL;

    cout << " Creating Rz TOIProcessors: RzTOIProc () " << endl;
    RzSimpleTOIProc rzs(w2, 3.);
    RzTOIProc rzp(w1, w2, nmax);
    if (fgsimple) {
      cout << " Using Simple TOIProcessor: RzSimpleTOIProc () " << endl;
      rzs.addInput("in", toi);
      rzs.addOutput("out", toi2);
      }
    else {
      cout << " Using Rz TOIProcessor: RzTOIProc () " << endl;
      //      rzp.setOutPPF("/data/Archeops/toto.ppf");
      rzp.setOutPPF(ppffile);
      rzp.addInput("in", toi);
      rzp.addOutput("out", toi2);
    }


    w.addInput("bolodrift", toi2);

    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    r.PrintStatus(cout);  
    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    w.PrintStatus(cout);  

    PrtTim("starting threads");
    r.start();
    if (fgsimple) rzs.start();
    else rzp.start();
    w.start();
    
    //    for(int jj=0; jj<3; jj++) {
    //      sleep(2);
    //      cout << *toi; 
    //    }

    mgr->joinAll();
    PrtTim("End threads");

    //    cout << " ------ FITSReaderTOI::PrintStatus() : ----- " << endl;
    //    r.PrintStatus(cout);  
    //    cout << "----- FITSWriterTOI::PrintStatus() : ----- " << endl;
    //    w.PrintStatus(cout);  

    cout << " ------ toi and toi2 Status information ------- " << endl;
    cout << *toi; 
    cout << *toi2;
  }
  catch (PThrowable & exc) {
    cerr << "\nrztsttoi: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\nrztsttoi: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\nrztsttoi: some other exception was caught ! " << endl;
  }

  return(0);
}
