#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "pipixmapx.h"

static  GC    mygc;

/* --Methode-- */
PIPixmapX::PIPixmapX(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PIPixmapGen(par,nom,sx,sy,px,py) 
{
Init();
AllocXImg();
}


/* --Methode-- */
PIPixmapX::~PIPixmapX()
{
delete[] myximg->data;
XFree(myximg); 
}

/* --Methode-- */
void PIPixmapX::Refresh()
{
int i,j;
unsigned char *pp;

if (pixmap)
  {
  for(j=0; j<ny; j++)
    {
    pp = pixmap+j*nx;
    for(i=0; i<nx; i++)
      { XPutPixel(myximg, i, j, cmap->Color(*pp) );  pp++; }
    }

  for(j=ny; j<YSize(); j++)
    for(i=nx; i<XSize(); i++)
      XPutPixel(myximg, i, j, 0 );
  }
PIBaseWdgX::Refresh();
}


/* --Methode-- */
void PIPixmapX::Resize()
{
delete[] myximg->data;
XFree(myximg); 
AllocXImg();
}
/* --Methode-- */
void PIPixmapX::Draw()
{
Draw(0, 0, XSize(), YSize());
}

/* --Methode-- */
void PIPixmapX::Draw(int x0, int y0, int dx, int dy)
{
Window xw;
Display * mdsp;
if ((myximg == NULL) || (cmap == NULL)) return;

xw = XtWindow(XtWdg());
mdsp = PIXDisplay();

if (x0 < 0)  x0 = 0;
if (y0 < 0)  y0 = 0;

if (dx > (XSize()-x0)) dx = XSize()-x0;
if (dy > (YSize()-y0)) dy = YSize()-y0;
if ((dx <= 0) || (dy <= 0))  return;

if ( (nx < x0 ) || (ny < y0) )
  { XClearArea(mdsp, xw, x0, y0, dx, dy, False);  return; }

if (nx < (x0+dx))
  { XClearArea(mdsp, xw, nx, y0, x0+dx-nx, dy, False);  dx = nx-x0; }
if (ny < (y0+dy))
  { XClearArea(mdsp, xw, x0, ny, dx, y0+dy-ny, False);  dy = ny-y0; }
  
XPutImage(mdsp, xw, mygc, myximg, x0, y0, x0, y0, dx, dy);
XFlush(mdsp);

return;
 
}

static bool fgxpxm = false;


/* --Methode-- */
void PIPixmapX::Init()
{
XGCValues       values;
XtGCMask        mask;
Display *mdsp;
int scr;

if (fgxpxm)  return; 
fgxpxm = true;

mdsp = XtDisplay(XtWdg());
scr = XDefaultScreen(mdsp);

mask = GCFunction | GCPlaneMask;
// mask = GCForeground | GCBackground;
values.function = GXcopy;
values.plane_mask = ~0;
// values.foreground = WhitePixel(mdsp, scr);
// values.background = BlackPixel(mdsp, scr);
mygc = XtGetGC(XtWdg(), mask, &values);

return;
}


/* --Methode-- */
void PIPixmapX::AllocXImg()
{
Window xw;
Display * mdsp;
int scr;
int depth;
int pad;
int i,j;

xw = XtWindow(XtWdg());
mdsp = PIXDisplay();
scr = PIXScreen();

depth = DefaultDepth(mdsp,scr);
pad = (depth > 8) ? 32 : 8;
myximg = XCreateImage (mdsp,DefaultVisual(mdsp,scr),
           depth,ZPixmap,0,NULL, XSize(), YSize(), pad,0);
if (myximg == NULL)  return;
myximg->data = new char [YSize()*myximg->bytes_per_line];
if (myximg->data == NULL)  
  { XFree(myximg); myximg = NULL; } 

for(j=0; j<YSize(); j++)
  for(i=0; i<XSize(); i++)
    XPutPixel(myximg, i, j, 0 );

return;
}
