#include <stdlib.h>
#include <stdio.h>

#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 
// #include PIMENUBAR_H 
#include PISTDWDG_H 
#include PIBWDG_H 

#include PIPIXMAP_H 

#include PIFILECHO_H 

#include "ex_dessin.h"
#include "sc_sample.h"
#include "piimage.h"

RzImage * RzReadFits(char *flnm);

int SysBeep(int n)
{
for(int i=0; i<n; i++)  putchar('\007');
return(0);
}
/*
class PITestWindow : public PIWindow {
public:
	PITestWindow(PIMsgHandler *par);
	~PITestWindow() {}

    PIText text;
    PIButton bouton;
    PIButton bouton2, bouton3;
    PILabel label;
    PIScale scl;
    PIPUMenu  * menu;

};
*/

class PITestApp : public PIApplication {
public:
	PITestApp(int sx, int sy);
	~PITestApp();

	virtual void	Process(long msg, PIMsgHandler* sender, void* data=NULL);

//    PIMenubar * menb;
    PIPDMenu  *m[3];
    PICheckBox * ckb;
    PIText * text;
    PIButton * bouton;
    PIButton * bouton2, * bouton3, * bouton4, *bouton5;
    PILabel * label;
    PIScale * scl;
    PIPUMenu  * menu;
    PIPUMenu * pum[2];
    PIOptMenu * opt, * opt2, *opt3;
    PIPixmap * zoom;
    PILabel  * labimg;
    ScSample * scs;

};


/*
PITestWindow::PITestWindow(PIMsgHandler *par)
: PIWindow(par, "Peida", PIWK_normal, 200, 200, 50, 50),
  text(this, "TEXTE", 100, 30, 20,10),
  label(this, "Label", 100, 20, 20,60),
  bouton(this, "OK", 66, 40, 20, 20, 100),
  bouton2(this, "Image", 133, 40, 20, 80, 100),
  bouton3(this, "Menu", 555, 40, 20, 140, 100),
  scl(this, "Scale", 88, 5, 45, 100, 20, 10, 130)
{
  menu = new PIPUMenu((PIMsgHandler *)this, "myMenu");
  menu->AppendItem("DoIt-1", 4401);
  menu->AppendItem("DoIt-2", 4402);
  menu->AppendItem("DoIt-25", 4425);
  menu->AppendItem("DoIt-26", 4426);
  menu->AppendItem("Check-33", 4433);
  menu->AppendItem("Check-33", 4433);

  label.SetBorderWidth(3);
  FinishCreate();
}

*/

PITestApp::PITestApp(int sx, int sy)
: PIApplication(sx, sy)
{
//   menb = new PIMenubar(this, "MyMenubar");
   m[0] = new PIPDMenu((PIMsgHandler *)Menubar(),"File");
   m[0]->AppendItem("Open", 10101);
   m[0]->AppendItem("Close", 10102);
   m[0]->AppendItem("New", 10103);
   m[0]->AppendItem("Quit", 10104);
   m[1] = new PIPDMenu((PIMsgHandler *)Menubar(),"Edit");
   m[1]->AppendItem("Copier", 10201);
   m[1]->AppendItem("Coller", 10202);
   m[1]->AppendItem("Couper", 10203);
   m[2] = new PIPDMenu((PIMsgHandler *)Menubar(),"Operation");
   m[2]->AppendItem("AddItem", 10301);
   m[2]->AppendItem("DelItemName", 10302);
   m[2]->AppendItem("DelItemMsg", 10303);

   AppendMenu(m[0]);
   AppendMenu(m[1]);   
   AppendMenu(m[2]);

  ckb = new PICheckBox(this->MainWin(), "CheckBox", 166, 60, 20, 10, 10);
  text = new PIText(this->MainWin(), "TEXTE", 100, 30, 20,40);
  label  = new PILabel(this->MainWin(), "Label", 140, 20, 20,80);
  label->SetBorderWidth(1);
  bouton = new PIButton(this->MainWin(), "OK", 33, 40, 25, 20, 120);
  bouton2 = new PIButton(this->MainWin(), "Image", 133, 40, 25, 80, 120);
  bouton3 = new PIButton(this->MainWin(), "ExDess",  233, 40, 25, 140, 120);
  bouton4 = new PIButton(this->MainWin(), "Dialog", 333, 40, 25, 200, 120);
  bouton5 = new PIButton(this->MainWin(), "ScDraw", 433, 40, 25, 260, 120);
  scl = new PIScale(this->MainWin(), "Scale", 88, 5, 45, 100, 20, 10, 150);

  zoom = new PIPixmap(this->MainWin(), "Zoom", 100,100,5,195);
  labimg = new PILabel(this->MainWin(), "PixelValue", 250, 20, 10, 320);

  menu = new PIPUMenu((PIMsgHandler *)this, "myMenu");
  menu->AppendItem("DoIt-1", 4401);
  menu->AppendItem("DoIt-2", 4402);
  menu->AppendItem("DoIt-25", 4425);
  menu->AppendItem("DoIt-26", 4426);
  menu->AppendItem("Check-33", 4433);
  menu->AppendItem("Check-33", 4433);

  pum[1] = new PIPUMenu((PIMsgHandler *)this,"Edit");
  pum[1]->AppendItem("Copier", 80201);
  pum[1]->AppendItem("Coller", 80202);
  pum[1]->AppendItem("Couper", 80203);
  pum[1]->AppendItem("Undo", 80204);
  pum[1]->AppendItem("Select-All", 80205);

  pum[0] = new PIPUMenu((PIMsgHandler *)this, "myMenu");
  pum[0]->AppendItem("Linear", 5601);
  pum[0]->AppendItem("Log.", 5602);
  pum[0]->AppendItem("Sqrt", 5603);
  pum[0]->AppendItem("Expon", 5604);
  pum[0]->AppendItem("Polyn", 5605);

  opt = new PIOptMenu(this->MainWin(), pum[0], 90, 25, 110, 150);
  opt->SetValueStr("Sqrt");
  opt2 = new PIOptMenu(this->MainWin(), pum[1], 90, 25, 150, 200);

  opt3 = new PIOptMenu(this->MainWin(), pum[0], 80, 25, 110, 250);
  opt3->SetValueStr("Linear");

}

PITestApp::~PITestApp()
{
  delete ckb;
  delete text;
  delete label;
  delete bouton;
  delete bouton2;
  delete bouton3;
  delete bouton4;
  delete bouton5;
  delete scl;
  delete menu;
  delete m[0]; delete m[1]; delete m[2];
  delete opt;
  delete opt2;
  delete opt3;
  delete pum[0];  delete pum[1]; 
  delete zoom;
  delete labimg;

}

static int nimg = 0;
static PIImage *pimg[5];
static RzImage *img[5];
static PIWindow *imgw[5];
static PIImage *cur=NULL;
static ScSample *scs1, *scs2;

static PIWindow * wp3, *wp2, *wp4, *wp5;
static PIPixmap * pxm;
static unsigned char  pixels[25000];
static PIFileChooser *pfc;
static bool  fgpxm = false;
static bool  fgt = false;
static bool  fgt2 = false;

void
PITestApp::Process(long msg, PIMsgHandler* sender, void* data)
{
  static int x = 0;
  static numsg=8800;

//   SysBeep(1);
  char truc[100];
  sprintf(truc,"< %ld - %d (%d)>",msg,x++, (int)((PIWdgGen *)sender)->kind());
  this->label->SetLabel(truc);

  if (msg == PIMsg_ActiveWdg) 
    { /* printf("Process: Setting active ImageWindow (%lx) \n", (long)data); */
    cur = (PIImage *)data; }

  if (msg == 33) ckb->SetState(true);
    
  if (msg == 133)
    {
    if (!fgpxm)  { wp3->Show();  fgpxm = true; }
    for (int i=0; i<25000; i++)  pixels[i] = rand()%32;
    if ((x % 3) == 0)  pxm->SetColMap(CMAP_GREY32);
    if ((x % 3) == 1)  pxm->SetColMap(CMAP_COLRJ32);
    if ((x % 3) == 2)  pxm->SetColMap(CMAP_COLBR32);
//    pxm->Refresh();
    if (cur)
      {
//      printf("Process: Setting ColMap for (%lx) \n", (long)cur);
      if ((x % 3) == 0)  cur->SetColMap(CMAP_GREY32);
      if ((x % 3) == 1)  cur->SetColMap(CMAP_COLRJ32);
      if ((x % 3) == 2)  cur->SetColMap(CMAP_COLBR32);
      }
    }
  if (msg == 233)
    {
    if (fgt) { wp2->Hide();  fgt = false; }
    else { wp2->Show();  fgt = true; }
    }

  if (msg == 333)  wp4->Show();
  if ( (msg == 6001) || (msg == 6002) )  wp4->Hide();

  if (msg == 433)
    {
    if (fgt2) { wp5->Hide();  fgt2 = false; }
    else { wp5->Show();  fgt2 = true; }
    }

//  if (msg == 555)   (this->menu)->Show(); 

  if (msg == 10104)  Stop();
  if (msg == 10101)  { pfc->AcceptNewFile(false); pfc->Show(); }
  if (msg == 10103)  { pfc->AcceptNewFile(true); pfc->Show(); }

  if (msg == 10301)  
   { 
   numsg++;    
   m[1]->AppendItem((char *)text->GetText().c_str(), numsg); 
   opt2->SetValue(numsg);
   }

  if (msg == 10302)  { m[1]->DeleteItem((char *)text->GetText().c_str()); }
  if (msg == 10303)  
    {
    long ml =  atol(text->GetText().c_str());
    m[1]->DeleteItemMsg(ml);
    opt2->SetValue(10201);
    }


  if ((msg > 8000) && data) printf("PITestApp::MenubarReturn: %s \n", (char *)data);
  if (msg == 5000)  
    { 
    if (data) 
      { 
      printf("PITestApp::Process(5000) : %s \n", (char *)data); 
      if (nimg < 5)  img[nimg] = RzReadFits((char *)data);
      if (img[nimg])
        {
        imgw[nimg] = new PIWindow(this, "WindImage", 
                                  PIWK_normal, 400, 400, 500, 500);
        pimg[nimg] = new PIImage(imgw[nimg], "MyImage", 400, 400, 0, 0);
        pimg[nimg]->SetBinding(true, true, true, true);
        pimg[nimg]->SetZoomWin(zoom);
        pimg[nimg]->SetTextWin(labimg);
        pimg[nimg]->SetImage(img[nimg]);
        pimg[nimg]->Apply();
        imgw[nimg]->Show();
        nimg++;
        }
    }
    else printf("PITestApp::Process(5000) (data=NULL) \n");  }

  if ((msg / 100) == 56) 
    printf("PITestApp::Process(%d) : %s \n", (int)msg, (char *)data); 

}

int main()
{
  PITestApp * app;
  app = new PITestApp(350, 350);

  wp2 = new PIWindow(app, "Window-2", PIWK_normal,  150, 150, 250, 250);
  ExBWdg bw(wp2, "BWdg", 150, 150, 0, 0);
//  bw.SetBinding(false, true, true, false);
//  bw.ActivateButton(1);
//  bw.ActivatePtrCross();
//  bw.ActivateKeyboard();

  wp4 = new PIWindow(app, "Window-4", PIWK_dialog,  120, 120, 350, 350);
  PIButton bt1(wp4, "OK", 6001, 40, 20, 10, 80);
  PIButton bt2(wp4, "Cancel", 6002, 40, 20, 60, 80);
  PILabel  lb1(wp4, "Mat_00", 30, 20, 10, 10);
  PIText  tx1(wp4, "A00", 50, 20, 50, 10);  
  PILabel  lb2(wp4, "Mat_11", 30, 20, 10, 40);
  PIText  tx2(wp4, "A11", 50, 20, 50, 40);  

  wp3 = new PIWindow(app, "Window-3", PIWK_normal, 200, 200, 350, 350);
  pxm = new PIPixmap(wp3, "myPixmap", 150, 150, 10, 10);
  pxm->SetBinding(true, true, true, true);
  pxm->SetPixmap(pixels, 150, 150);

  wp5 = new PIWindow(app, "Window-5", PIWK_normal,  400, 200, 200, 200);
  scs1 = new ScSample(wp5, "ScSample", 200, 200, 0, 0);
  scs1->SetBinding(true, true, true, true);
  scs2 = new ScSample(wp5, "ScSample", 200, 200, 200, 0);
  scs2->SetBinding(true, true, true, true);

  //  wp4 = new PIWindow(app, "Open...", PIWK_dialog, 300, 300, 400, 400);

  pfc = new PIFileChooser(app,"FileChooser", 5000); 
  pfc->SetPath("/exp/eros/ImagRed/");


//  Int32 ioNumber = 100;
  app->Run();
  delete app;
  exit(0);
}
