// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2map.h,v 1.13 2001-12-01 13:34:09 aubourg Exp $

#ifndef TOI2GMAP_H
#define TOI2GMAP_H

#include "toiprocessor.h"
#include "toiprocessor.h"
#include "spherehealpix.h"
#include "localmap.h"
#include "flagtoidef.h"
#include "xastropack.h"

//-- Un projecteur de TOI sur une carte quelconque
// Lecture de 3 TOI coord1,coord2,boloMuV
// Sortie pas de TOI, une (2) cartes
//
// Structure generale :
//                          |---->Carte
//                          |
//                     -----------
//   toi Coord1In ---> |         |
//   toi Coord2In ---> | TOI2Map |
//   toi BoloIn   ---> |         |
//                     -----------
// Gestion du type de coordonnees :
// Coord1In,Coord2In : soit Equatoriales (Alpha,Delta)
//                     soit Galactiques  (GLong,GLat)
// Sortie sur une sphere en coordonnees Equatoriales ou Galactiques
// Si les CoordIn et les CoordOut sont equatoriales -> meme equinoxe!

class TOI2Map : public TOIProcessor {
public:
                 TOI2Map(PixelMap<r_8>* map,PixelMap<r_8>* wmap=NULL);
  virtual	~TOI2Map();

  virtual void	init(void);
  virtual void	run(void);

  // Coordonnees donnees en entree et en sortie
  inline void SetEquinox(double actualyear=2000.)
              {mActualYear = actualyear;}
  inline void SetCoorIn(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorIn = mfg;}
  inline void SetCoorOut(TypAstroCoord mfg=TypCoordGalStd)
              {mTypCoorOut = mfg;}
  // Test on flag value ? if yes, BAD sample have flag matching mBadFlag
  inline void SetTestFlag(bool tflg=false, uint_8 badflg=FlgToiAll)
              {mTFlag = tflg; mBadFlag = badflg;}
  // Test on min value ? if yes, GOOD sample have value >= mValMin
  // Test on max value ? if yes, GOOD sample have value <= mValMax
  // Good values are (mValMin <= sample value <= mValMax)
  //                      bounds are included
  inline void SetTestMin(bool tmin=false, r_8 vmin=-1.e30)
              {mTMin = tmin; mValMin = vmin;}
  inline void SetTestMax(bool tmax=false, r_8 vmax=+1.e30)
              {mTMax = tmax; mValMax = vmax;}
  // Print
  void Print(::ostream & os);

  void SetIsColat(bool b=true) {mIsColat=b;} // latitude is a colatitude, 0-Pi
protected:
  PixelMap<r_8>* mMap;
  PixelMap<r_8>* mWMap;
  bool mWMapInternal;

  TypAstroCoord mTypCoorIn, mTypCoorOut;
  double mActualYear;

  bool mTFlag,mTMin,mTMax;
  bool mIsColat; // temporary fix
  uint_8 mBadFlag;
  r_8 mValMin,mValMax;
};

#endif
