// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: map2toi.cc,v 1.10 2001-12-03 20:38:02 cmv Exp $

#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "map2toi.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Map2TOI::Map2TOI(SphereHEALPix<r_8>& sph)
: mSph(sph)
{
 SetBad();
 SetEquinox();
 SetCoorIn();
 SetCoorMap();
}

Map2TOI::~Map2TOI()
{
}

////////////////////////////////////////////////////////////////////////
void Map2TOI::Print(::ostream & os)
{
 os<<"Map2TOI::Print -- Sphere NLat = "<<mSph.SizeIndex()<<endl
   <<"   - Equinoxe:   "<<mActualYear<<" y"<<endl
   <<"   - TypCoorIn:  "<<mTypCoorIn<<" = "<<DecodeTypAstro(mTypCoorIn)<<endl
   <<"   - TypCoorMap: "<<mTypCoorMap<<" = "<<DecodeTypAstro(mTypCoorMap)<<endl;
}

////////////////////////////////////////////////////////////////////////
void Map2TOI::init() {
  cout << "Map2TOI::init" << endl;
  declareInput("Coord1In");     // input  index 0
  declareInput("Coord2In");     // input  index 1
  declareOutput("Coord1Out");   // output index 0
  declareOutput("Coord2Out");   // output index 1
  declareOutput("BoloOut");     // output index 2
}

////////////////////////////////////////////////////////////////////////
void Map2TOI::run() {

if(mSph.NbPixels()<1) {
  cout<<"Map2TOI::Map2TOI() Bad number of pixels in sphere "<<mSph.NbPixels()<<endl;
  throw ParmError("Map2TOI::Map2TOI() - Bad number of pixels in sphere");
}

long snb = getMinIn();
long sne = getMaxIn();
if(snb>sne) {
  cout<<"Map2TOI::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("Map2TOI::run() - Bad sample interval");
}
if(!checkInputTOIIndex(0) || !checkInputTOIIndex(1)) {
  cout<<"Map2TOI::run() - Input TOI (Coord1In or Coord2In) not connected! "<<endl;
  throw ParmError("Map2TOI::run() Output TOI (Coord1In or Coord2In) not connected!");
}
bool connected_Coord1Out = checkOutputTOIIndex(0);
bool connected_Coord2Out = checkOutputTOIIndex(1);
if(!checkOutputTOIIndex(2)) {
  cout<<"Map2TOI::run() - Output TOI (BoloOut) not connected! "<<endl;
  throw ParmError("Map2TOI::run() Output TOI (BoloOut) not connected!");
}
if( !(mTypCoorIn&TypCoordEq || mTypCoorIn&TypCoordGal) ) {
  cout<<"Map2TOI::run() - CoordIn Coordinates not Eq or Gal! "<<endl;
  throw ParmError("Map2TOI::run() - CoordIn Coordinates not Eq or Gal!");
}
if( !(mTypCoorMap&TypCoordEq || mTypCoorMap&TypCoordGal) ) {
  cout<<"Map2TOI::run() - Sphere Coordinates not Eq or Gal! "<<endl;
  throw ParmError("Map2TOI::run() - Sphere Coordinates not Eq or Gal!");
}

//---------------------------------------------------------
try {

double mjd = MJDfrYear(mActualYear);
cout<<"Map2TOI::run() - modified Julian day "<<mjd<<endl;

uint_4 mSnRead=0, mSnFilled=0, BadCoorRange=0;

for(int k=snb;k<=sne;k++) {

  uint_8 flg = 0;
  double coord1 = getData(0,k);
  double coord2 = getData(1,k);
  double c1 = coord1, c2=coord2, bolo = -99999.;
  mSnRead++;

  // Conversion de CoordIn to Standard
  double phi=-1.;
  CoordConvertToStd(mTypCoorIn,&c1,&c2);

  // Conversion dans le systeme astronomique approprie
  if(mTypCoorIn&TypCoordEq && mTypCoorMap&TypCoordGal) { // CIn=Eq  CMap=Gal
    EqtoGal(mjd,c1,c2,&c1,&c2);
    phi   = c1 * Pi/180.;
  } else if(mTypCoorIn&TypCoordGal && mTypCoorMap&TypCoordEq) { // CIn=Gal CMap=Eq
    GaltoEq(mjd,c1,c2,&c1,&c2);
    phi   = c1 * Pi/12.;
  } else if(mTypCoorMap&TypCoordGal) { // CIn=Gal CMap=Gal
    phi   = c1 * Pi/180.;
  } else if(mTypCoorMap&TypCoordEq) { // CIn=Eq CMap=Eq
    phi   = c1 * Pi/12.;
  }
  ToCoLat(&c2,TypUniteD);
  double theta = c2 * Pi/180.;
  if(phi<0. || phi>=2*Pi || theta<0. || theta>Pi)
               {BadCoorRange++; flg = mBadFlag; }

  if(!flg) {
    bolo = mSph(theta,phi);
    mSnFilled++;
  }

  if(connected_Coord1Out) putData(0,k,coord1,flg);
  if(connected_Coord2Out) putData(1,k,coord2,flg);
  putData(2,k,bolo,flg);
}

cout<<"TOI2Map::run: Samples Read "<<mSnRead
    <<" Filled "<<mSnFilled
    <<" BadCoorRange="<<BadCoorRange<<endl;

//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Map2TOI: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;                                                                            
}
