//#define TOISEQBUFFERED

#include <unistd.h>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#ifdef TOISEQBUFFERED
#include "toiseqbuff.h"
#else
#include "toisegment.h"
#endif

#include "sambainit.h"
#include "map2toi.h"
#include "fitsspherehealpix.h" 
#include "timing.h"

#include <stdexcept>

void usage(void);
void usage(void) {
 cout<<"tstmap2toi [-h] [-p lp] [-s samplemin,samplemax] [-w data_window_size]"<<endl
     <<"           [-a label_coord1In] [-d label_coord2In] [-b label_bolomuv]"<<endl
     <<"           [-i c,h] [-m c,h]"<<endl
     <<"           fitsin_point fitsphere fitsout"<<endl
     <<" -p lp : print level (def=0)"<<endl
     <<" -s samplemin,samplemax : sample range to be treated (def=all)"<<endl
     <<" -w data_window_size : window size for pipe (def=8192)"<<endl
     <<" -a label_coord1 : label fits for alpha/gLong (def=coord1)"<<endl
     <<" -d label_coord2 : label fits for delta/gLat (def=coord2)"<<endl
     <<"          coord1 = alpha or gLong ; coord2 = delta or gLat"<<endl
     <<" -b label_bolomuv : label fits for bolo value (def=boloMuV)"<<endl
     <<" -i cin : coordIn caracteristics (def=\"gdcdl\")"<<endl
     <<" -m cmap : idem -i for Sphere (def=\"g\")"<<endl
     <<" -e equi : equinoxe en annee (def=2000.)"<<endl
     <<" -I : sampleNum are implicit in fits files (def=no)"<<endl
     <<" fitsin_point : fits file for pointing"<<endl
     <<" fitsphere : fits file for input Healpix sphere"<<endl
     <<" fitsout : fits file for output"<<endl;
 return;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
int lp = 0, width = 8192;
char *label_coord1 = "coord1", *label_coord2 = "coord2", *label_bolomuv = "boloMuV";
char *tcoorin="gdcdl", *tcoormap="g";
double equi=2000.;
long sdeb,sfin;
bool snimplicit = false;
int c;
while((c = getopt(narg,arg,"hIp:s:w:a:d:b:i:m:e:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
    else {cout<<"Bad sample interval "<<endl; exit(1);}
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'p' :
    sscanf(optarg,"%d",&lp);
    if(lp<0) lp=0;
    break;
  case 'a' :
    label_coord1 = optarg;
    break;
  case 'd' :
    label_coord2 = optarg;
    break;
  case 'b' :
    label_bolomuv = optarg;
    break;
  case 'i' :
    tcoorin = optarg;
    break;
  case 'm' :
    tcoormap = optarg;
    break;
  case 'e' :
    sscanf(optarg,"%lf",&equi);
    break;
  case 'I' :
    snimplicit = true;
    break;
  case 'h' :
  default:
    usage(); exit(1);
  }
}
if(optind+2>=narg) {usage(); exit(2);}
char * fitsin_point    = arg[optind];
string const fitsphere = arg[optind+1];
char * fitsout         = arg[optind+2];

cout<<">>>> tstmap2toi:"<<endl
    <<"Pipe Window Size "<<width<<endl
    <<"Fits OutFile "<<fitsout<<endl
    <<"  ...label_bolomuv "<<label_bolomuv<<endl;
cout<<"Fits Infile Pointing "<<fitsin_point<<endl
    <<"  ...label_coord1 "<<label_coord1<<endl
    <<"  ...label_coord2 "<<label_coord2<<endl
    <<"  ...... ctype="<<tcoorin<<endl;
cout<<"Fits Healpix Sphere "<<fitsphere<<endl
    <<"  ...... ctype="<<tcoormap<<endl;
cout<<"Equinoxe "<<equi<<" years"<<endl;

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------

 // FITS reader et writer
 FITSTOIReader rfits(fitsin_point);
 if(snimplicit) rfits.setImplicitSN();
 int ncol = rfits.getNOut();
 cout<<"Number of columns in fits Infile Pointing : "<<ncol<<endl;
 if(ncol<2) exit(3);

 FITSTOIWriter wfits(fitsout);
 if(snimplicit) wfits.setImplicitSN();
 //wfits.setOutFlags(true);
 cout << "fits reader and writer created"<<endl;

 // Lecture de la sphere Healpix
 SphereHEALPix<r_8> sph;        
 FitsInFile sfits(fitsphere);
 sfits >> sph;
 cout<<"SphereHEALPix: Type de map : "<<sph.TypeOfMap()<<endl
     <<"               Nombre de pixels : "<<sph.NbPixels()<<endl;

 // TOI Processor
 Map2TOI m2toi(sph);
 cout<<"Map2TOI created"<<endl;
 m2toi.SetEquinox(equi);
 m2toi.SetCoorIn(tcoorin);
 m2toi.SetCoorMap(tcoormap);
 m2toi.Print(cout);

 // Definition des tuyaux
#ifdef TOISEQBUFFERED
 cout<<">>>> Using TOISeqBuffered"<<endl;
 TOISeqBuffered * toicoord1in = new TOISeqBuffered("toi_coord1_in",width);
#else
 cout<<">>>> Using TOISegmented"<<endl;
 TOISegmented * toicoord1in = new TOISegmented("toi_coord1_in",width);
#endif
 // toicoord1in->setDebugLevel(1);
 rfits.addOutput(label_coord1,toicoord1in);
 m2toi.addInput("Coord1In",toicoord1in);

#ifdef TOISEQBUFFERED
 TOISeqBuffered * toicoord1out = new TOISeqBuffered("toi_coord1_out",width);
#else
 TOISegmented * toicoord1out = new TOISegmented("toi_coord1_out",width);
#endif
 m2toi.addOutput("Coord1Out",toicoord1out);
 wfits.addInput(label_coord1,toicoord1out);

#ifdef TOISEQBUFFERED
 TOISeqBuffered * toicoord2in = new TOISeqBuffered("toi_coord2_in",width);
#else
 TOISegmented * toicoord2in = new TOISegmented("toi_coord2_in",width);
#endif
 // toicoord2in->setDebugLevel(1);
 rfits.addOutput(label_coord2,toicoord2in);
 m2toi.addInput("Coord2In",toicoord2in);

#ifdef TOISEQBUFFERED
 TOISeqBuffered * toicoord2out = new TOISeqBuffered("toi_coord2_out",width);
#else
 TOISegmented * toicoord2out = new TOISegmented("toi_coord2_out",width);
#endif
 m2toi.addOutput("Coord2Out",toicoord2out);
 wfits.addInput(label_coord2,toicoord2out);

#ifdef TOISEQBUFFERED
 TOISeqBuffered * toibolout = new TOISeqBuffered("toi_bolo_out",width);
#else
 TOISegmented * toibolout = new TOISegmented("toi_bolo_out",width);
#endif
 // toibolout->setDebugLevel(1);
 m2toi.addOutput("BoloOut",toibolout);
 wfits.addInput(label_bolomuv,toibolout);

 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;
 rfits.PrintStatus(cout);
 cout<<"----- FITSWriterTOI::PrintStatus() : -----"<<endl;
 wfits.PrintStatus(cout);  

 PrtTim("starting threads");
 rfits.start();
 m2toi.start();
 wfits.start();

 //if(lp>1) for(int jjjj=0;jjjj<5;jjjj++) {
 //  cout<<*toicoord1in; 
 //  cout<<*toibolout; 
 //  sleep(2);
 //}

 //  Affichage de l'avancement des TOIProcessors 
 //ProcSampleCounter<FITSTOIReader>  stats(rfits);
 //stats.InfoMessage() = "tstmap2toi/Info";
 //stats.PrintStats();

 mgr->joinAll();
 PrtTim("End threads");

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntstmap2toi: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntstmap2toi: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntstmap2toi: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
