/* Interface Fits BINARY/ASCII Table Writer    cmv 26/09/2001 */
#ifndef FABTWRITER_H_SEEN
#define FABTWRITER_H_SEEN

#include "machdefs.h"
#include <iostream.h>
#include <string.h>
#include <string>

#include "anydataobj.h"
#include "tvector.h"
#include "FitsIO/fitsio.h"

#include <vector>

namespace SOPHYA {

//! Class for writing a FITS ASCII or BINARY table
class FitsABTWriter : public AnyDataObj {
public:
  FitsABTWriter(string fname,int hdutype=BINARY_TBL,int lp=0);
  FitsABTWriter(const char* cfname,int hdutype=BINARY_TBL,int lp=0);
  virtual ~FitsABTWriter();

  void Flush(void);

  //! Write a double value in Fits header.
  void WriteKey(const char *keyname,double val,char* comment=NULL);
  //! Write a long value in Fits header.
  void WriteKey(const char *keyname,long val,char* comment=NULL);

  //! Add a new column to the FITS table and return its number (see addcol).
  inline int AddCol(string label,string tform=string("")
                   ,string tunit=string(""),int datatype=TDOUBLE)
     {return addcol(label.c_str(),tform.c_str(),tunit.c_str(),datatype);}
  //! Add a new column to the FITS table and return its number (see addcol).
  inline int AddCol(const char* label,const char* tform=""
                   ,const char* tunit="",int datatype=TDOUBLE)
     {return addcol(label,tform,tunit,datatype);}

  //! Set the FITS table extension name
  inline void SetExtName(string extname=string("")) {ExtName = extname;}
  //! Set the FITS table extension name
  inline void SetExtName(char* extname="") {ExtName = extname;}
  //! Set debug level
  inline void SetDebug(int lp=0) {DbgLevel = (unsigned short) lp;}

  void Write(int col,long row,short val);
  void Write(int col,long row,int_4 val);
  void Write(int col,long row,float val);
  void Write(int col,long row,double val);
  long Write(int col,long row,TVector<int_4>& val);
  long Write(int col,long row,TVector<float>& val);
  long Write(int col,long row,TVector<double>& val);
  //! Return the number of overflows managed by cfitsio
  inline unsigned long GetNOverFlow(void) {return NOverFlow;}

  //! Return the number of created columns
  inline int GetNbCol(void) {return (int) Label.size();}

  //! Print to os
  virtual void   Print(ostream& os,int lp=1) const;
  //! Print to stdout
  inline  void   Print(int lp=1) const {Print(cout,lp);}

protected:
  struct KeyDouble {string keyname; double val; string comment;};
  struct KeyLong   {string keyname; long   val; string comment;};

  void createfits(const char *cfname,int hdutype,int lp);
  int addcol(const char* label,const char* tform
            ,const char* tunit,int datatype);
  void createtbl(void);
  void writekeys(void);
  void printerrorwrite(const char* type,int col,long row,int sta);
  void printerror(int sta) const;

  string FitsFN,ExtName;
  int HduType;
  unsigned short DbgLevel;
  fitsfile *FitsPtr;
  bool FirstTime;
  vector<string> Label;
  vector<string> TForm;
  vector<string> TUnit;
  unsigned long NOverFlow;

  vector<struct KeyDouble> DoubleKey;
  vector<struct KeyLong>   LongKey;
};

} // namespace SOPHYA
#endif    /* FABTWRITER_H_SEEN */
