#ifndef DATACIRCLEBASE_H_SEEN
#define DATACIRCLEBASE_H_SEEN

#include "circle.h"

static long l_ft_nint(double x) {
  return ( (x < 0.) ? (long)(x-0.5) : (long)(x+0.5) ) ;
}

class DataCircleBase : public Circle {

 public:

  DataCircleBase() {;}
  DataCircleBase(double theta,double phi,double aperture) : Circle(theta,phi,aperture) {;}

  virtual ~DataCircleBase() {;}

  virtual int NMeasurements() const = 0;
  virtual double getData(double) const = 0;
  virtual double getTMeasure(double) const = 0;

  virtual void print(ostream&) const= 0;

  // Pour compatibilite avec les autres classes  
  inline void Print(ostream& s) const { print(s); }
};

inline ostream& operator<<(ostream& s, const DataCircleBase& c)
{
  c.Print(s);
  return s;
}

#endif
