#ifndef GPC_MISC_H
#define GPC_MISC_H

#ifndef __cplusplus
#undef bool
typedef unsigned int bool;
#endif

/* TRUE or FALSE */
#define TBOOLEAN bool
#define EMPTY_LABELSTRUCT {"", "", 0.0, 0.0}
#define NO_CARET (-1)
#define VERYLARGE 1e37

#define MAX_LINE_LEN 1024       /* maximum number of chars allowed on line */
#define MAX_ID_LEN 50  

#define ZERO 1e-8               /* default for 'zero' set option */
extern double zero;             /* zero threshold, not 0! */

/** labels **/
/* The data describing an axis label, or the plot title */
typedef struct {
    char text[MAX_LINE_LEN+1];
    char font[MAX_LINE_LEN+1];
    double xoffset, yoffset;
} label_struct;

typedef enum position_type {
    first_axes,
    second_axes,
    graph,
    screen
} position_type; 

/* A full 3D position, with all 3 coordinates of different axes,
 * possibly. Used for 'set label' and 'set arrow' positions: */
typedef struct position {
    enum position_type scalex,scaley,scalez;
    double x,y,z;
} t_position;

#endif /*ifndef GPC_MISC_H*/
