#ifndef PSFILE_H_SEEN
#define PSFILE_H_SEEN

/*
 *  PSFile.h
 * 
 *  14/06/96, 19/06/96
 *
 *  Gestion des fichier .ps et .eps
 *
 *     - L'unite de mesure est lUnite Courante (UC)
 *        Au depart, 1UC == 1cm 
 *     - Les reperes sont orientes a la maniere XWindow
 * 
 *  17/02/97 : modification des constructeurs(1-->eps,2-->ps)
 *             ajout du type enum orientation
 *
 */

#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef __mac__
#include <stat.h>
#endif
#include "pisysdep.h"
#include "pifontgen.h"

#include "pigraphgen.h"      // Types enumeres repris de PI:PIFontSize...
#include PICMAP_H

#include <list>

enum PIPaperSize { PI_A4 = 1, PI_A3 = 2, PI_A5 = 3, PI_NotDefPaperSize = 0};

enum PIOrientation { PI_Landscape = 0, PI_Portrait = 1, PI_Auto = 2 } ;


/*
 *#define PAGE_WIDTH   21.0    == 595 points 
 *#define PAGE_HEIGHT  29.7    == 842 points 
 *#define PORTRAIT  1
 *#define LANDSCAPE 0
 */



/* Valable pour une page, ou un bloc */
/*typedef struct {
 *  double X0;          Coordonnes sommet NO  
 *  double Y0;           en unites courantes  
 *  double Tx;          Format                
 *  double Ty;           en unites courantes  
 *  double Dx;          Coord sommet SE       
 *  double Dy;           en unites courantes  
 *  int orientation;   LANDSCAPE OU PORTRAIT 
 *} Format;
 */

/*
 *typedef struct{
 *    char *Name;
 *    int  Tx;     En 1/72e de pouce  !! 
 *    int  Ty;     unite naturelle de ps 
 *} PIMedia;
 */



class PSFile{

public:
    /* Definition de la resolution coordonnees user par defaut (point/cm) */ 
    static void SetUserCoordResolution(float resx, float resy);
    static float GetUserCoordResolution(float & resx, float & resy);
    static float PSCoordResolution(); 

    /* Production fichier eps */
    PSFile (const char * FileName, double sc = 1.0);
    /* Production fichier ps  */
    PSFile (const char * FileName, PIOrientation orientation, 
	    PIPaperSize paperSize= PI_A4, 
	    double marginX = 3.0, double marginY = 3.0 ) ;

    virtual      ~PSFile();

    virtual int     IsEPS();
    virtual const char*   GetFileName();


    /*    virtual Format* GetFormat(); */
    /* Attributs graphiques */
    virtual PIColors    GetDrawColor();
    virtual PIColors    GetFillColor();
    virtual PIFontAtt   GetFontAtt();
    virtual int         GetFontSize();
    virtual PILineAtt   GetLineAtt();
    virtual PIMarker    GetMarker();

    virtual void  NewPage(double Dx, double Dy, PIOrientation orientation);
    virtual void  EndPage();
    virtual void  NewBloc(double x0, double y0, double Tx, double Ty,
			  double Dx, double Dy);
    virtual void  EndBloc();

    virtual void SelForeground(PIColorMap& cmap, int cid) ; 
    virtual void SelBackground(PIColorMap& cmap, int cid) ; 

    /* Trace */
    virtual void  DrawString  (double x,  double y, const char *s, 
			       PIColors DrawColor  = PI_NotDefColor, 
			       PIFontName FontName = PI_DefaultFont,
			       PIFontAtt FontAtt   = PI_NotDefFontAtt, 
			       int FontSize        = 8, 
			       int pos = 0);
    virtual void  DrawLine    (double x1, double y1, double x2, double y2, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawBox     (double x0, double y0, double Tx, double Ty, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFBox    (double x0, double y0, double Tx, double Ty, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawCircle  (double x0, double y0, double r, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFCircle (double x0, double y0, double r,
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawPolygon (double *x, double *y, int n,
			       PIColors DrawColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt, 
                               bool cinc = true);
    virtual void  DrawFPolygon(double *x, double *y, int n,
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt, 
                               bool cinc = true);
    virtual void  DrawMarker  (double x0, double y0, 
			       PIMarker MrkType    = PI_NotDefMarker, 
			       PIColors DrawColor  = PI_NotDefColor,
			       int MarkerSize=14);
    virtual void  DrawMarkers (double *x0, double *y0, int n,
			       PIMarker MrkType    = PI_NotDefMarker,
			       PIColors DrawColor  = PI_NotDefColor,
			       int MarkerSize=14); 

    virtual void  Image(double x0, double y0, double Tx, double Ty,
			int Nx, int Ny,
			unsigned char *pict,
			PIColorMap *mColorMap);

// Declarations en public - sinon certains compilateurs cxx , aCC, xlC ont des problemes
    /* Blocs */
    typedef struct {
	int    num;
	char*  label;
	double  X0, Y0;            /* coordonnees sommet NO */
	double  Tx, Ty;            /* Format */
	double  Dx, Dy;            /* Repere utilisateur */
	long  begin,end,tmp;   /* offsets dans le fichier */
    } Bloc ;
    typedef list<Bloc> BlocList;  /* STL */


    /* Pages */
    typedef struct {
	int num;
	int BlocCounter;
	double Dx,Dy;              /* Sommet SE (unites utilisateur) */ 
        float FontScaleFactor;    /* Facteur d'echelle pour les fontes */ 
	PIOrientation orientation;
	long  begin, end, tmp;    /* Offsets dans le fichier */
	BlocList mBlocList;       /* Page == Liste de blocs  */
    } Page ;
    typedef list<Page> PageList;  /* STL */

private:

    /* Fichier ps/eps */
    FILE *   mPSFile;
    const char *   mPSFileName;
    double    Tw,Th ;              /* Format, en cm */
    double    WMargin,HMargin ;    /* Marges minimales */
    int      isEPS;               /* Vrai si PostScript Encapsule */
    long     boundingBox;         /* Endroit ou est specifiee la bb */
    double    scale;              /* boundingbox = Dx*scale ; Dy*scale */
    PIPaperSize mPaperSize ; 
    int      PageCounter;         /* nbr pages */
    int      FileEmpty;
    Page*    currentPage;        /* Avant empilage */
    Bloc*    currentBloc;        /* Avant empilage */
    PageList mPageList;          /* Fichier == Liste de pages */


    /* Attributs graphiques, initialises par constructeur */
    enum PIColors    mDrawColor;  /* Couleur de trace courante */
    enum PIColors    mFillColor;  /* Couleur de remplissage courante */
    enum PIFontAtt   mFontAtt; 
    //    enum PIFontSize  mFontSize; 
    int              mFontSize; 
    enum PIFontName  mFontName; 
    enum PILineAtt   mLineAtt;    /* Epaisseur d une ligne */
    enum PIMarker    mMarker;     /* Marker courant */
    int              mMarkerSize; /* Taille (en points) du marker courant */
    bool setFontDone ; /* Pour forcer la selection de Marker apres DrawString() */

  /* resolution coordonnees user (point/cm - pixels/cm) */
    static float  def_user_resol_X, def_user_resol_Y; 
    static float  def_user_resolution;
  /* resolution coordonnees PostScript (point/cm - pixels/cm) */
    static float  postscript_resolution;
} ;


#endif/* PSFILE_H_SEEN */
