// Module PI : Peida Interactive     PIGraphic 
// Primitives de trace graphiques    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

// Classe generique de trace graphique de base (Ne peut etre instancie)

#include "pigraphgen.h"

//++
// Class	PIGraphic
// Lib		PI
// include	pigraphgen.h
//
//   	Classe de base fournissant les services de trac graphique.
//   	La classe PIGraphicGen dfinit l'interface  travers des mthodes
//   	virtuelles pures. Les objets instancis doivent tre de la classe
//   	"PIGraphicWin" ou "PIGraphicUC" ou ...
//   	La classe "PIGraphicWin" a une implementation dpendante du systme 
//   	utilis (Mac, XWindow, ...). 
//   	Un type particulier *PIGrCoord* est dfini pour la spcification 
//	des coordonnes graphiques. 
//--
//++
// Links	Voir aussi
// PIGrCoord
// PIFont
// PIColorMap
//--

//++
// Titre	Constructeurs
//--
//++
// PIGraphic()
//	Constructeur utilis par les classes drives.
// PIGraphic(PIWdg* wdg)
//	Constructeur pour les *PIGraphicWin*. Objet "PIGraphic" capable 
//	de tracer dans un "PIWdg".
// PIGraphic(PIScreenBuffer* grb)
//	Constructeur pour objet "PIGraphic" capable de tracer dans un 
//	buffer graphique.
//--
//++
//--
// Titre	Mthodes
//++
// int  kind()
//	Renvoie le type de l'objet "PIGraphic" .
//	* PI_UnknownGraphics : Objet PIGraphic de type inconnue.
//	* PI_ScrBufferGraphics : Objet PIGraphic associ  un "GraphicBuffer"
//	* PI_ScrWindowGraphics : Objet PIGraphic associ  une fentre sur l'cran (PIWdg)
//	* PI_PSFileGraphics : Objet PIGraphic  un fichier PostScript (pour impression papier)
//	* PI_UCGraphics : Objet PIGraphic travaillant dans un systme de coordonnes utilisateur.
//	* PI_3DGraphics : Objet PIGraphic fournissant des mthodes de trac en coordonnes 3-D
// void  GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
//	Renvoie les limites de l'espace graphique - Coordonnes fentre pour un PIGraphicWin, 
//	Limites dfinies par l'utilisateur pour un PIGraphicUC
// void  Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy) 
//	Efface le rectangle dfini par le coin "x0,y0", de longeur et de largeur "dx,dy"
//	en utilisant la couleur d'arrire plan (Background)
//--


/* --Methode-- */
PIGraphicGen::PIGraphicGen()
{
myWdg = NULL;
myGrb = NULL;
}

/* --Methode-- */
PIGraphicGen::PIGraphicGen(PIWdg* wdg)
{
myWdg = wdg;
myGrb = NULL;
}

/* --Methode-- */
PIGraphicGen::PIGraphicGen(PIScreenBuffer* grb)
{
myWdg = NULL;
myGrb = grb;
}

/* --Methode-- */
PIGraphicGen::~PIGraphicGen()
{
}
/* --Methode-- */
int PIGraphicGen::kind() 
{
return PI_UnknownGraphics ;
}


/* --Methode-- */
void PIGraphicGen::GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
{
xmin = ymin = 0;  
xmax = ymax = 0;
if (myWdg) {
  xmax = myWdg->XSize();
  ymax = myWdg->YSize();
  }
}

//++ 
// Titre	Tracs de texte
//--
//++
// void  DrawString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0)
//	Trace la chane de caractres "s"  la position "x,y", 
//	en utilisant la couleur d'avant-plan (Foreground)
//	La chaine est trace avec une justification a gauche, ou droite,
//	ou centree (horzontal) - bas, haut, milieu (vertical), en fonction de
//	de la valeur du flag "pos"
//|	PI_HorizontalLeft PI_HorizontalCenter PI_HorizontalRight
//|	PI_VerticalBottom PI_VerticalCenter PI_VerticalTop
// void  DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0) 
//	Trace la chane de caractres "s"  la position "x,y" . La couleur d'
//	arrire-plan est utilise pour remplir la zone rectangulaire occupe par
//	le trac de texte.
//	La chaine est trace avec une justification a gauche, ou droite,
//	ou centree (horzontal) - bas, haut, milieu (vertical), en fonction de
//	de la valeur du flag "pos"
//|	PI_HorizontalLeft PI_HorizontalCenter PI_HorizontalRight
//|	PI_VerticalBottom PI_VerticalCenter PI_VerticalTop
//--

//++ 
// Titre	Tracs de lignes et de figures gometriques
//--
//++
// void  DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
//	Trace une ligne entre les points de coordonnes "(x1,y1)" et "(x2,y2)", 
//	en utilisant la couleur d'avant-plan (Foreground)
// void  DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac du contour d'un rectangle dfini par la position du coin "(x0,y0)"
//	et de taille "dx,dy" avec la couleur d'avant-plan.
// void  DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac d'un rectangle plein, dfini par la position du coin "(x0,y0)"
//	et de taille "dx,dy" avec la couleur d'avant-plan.
// void  DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)  
//	Trac du contour d'un cercle centr en "(x0,y0)", de rayon "r"
// void  DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)  
//	Trac d'un cercle plein centr en "(x0,y0)", de rayon "r"
// void  DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac d'une ellipse incluse dans le rectangle "(x0,y0)" , "dx,dy"
// void  DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac d'une ellipse pleine incluse dans le rectangle "(x0,y0)" , "dx,dy"
// void  DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)
//	Trac du contour d'un polygone dfini par le tableau des "n" points "x,y".
//	Si "cinc==true", les coordonnes seront considres comme relatives
//	 la position du point "(x[0], y[0])". Dans le cas contraire, chaque couple
//	"(x[i], y[i])" reprsentera les coordonnes absolues d'un coin du polygone.
// void  DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)
//	Trac d'un polygone plein de la couleur d'avant-plan.
// void  DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, double degdeb, double degfin)
//	Trac d'un arc de cercle ou d'ellipse, inclu dans le "(x0,y0)" , "dx,dy" 
//	entre les angles (en degr) "degdeb" - "degfin" 
// void  DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, double degdeb, double degfin)
//	Trac d'un arc plein, inclu dans le "(x0,y0)" , "dx,dy" 
//	entre les angles (en degr) "degdeb" - "degfin" 
//--

//++ 
// Titre	Tracs de signes
//--
//++
// void  DrawMarker(PIGrCoord x0, PIGrCoord y0)  
//	Trac d'un signe au point "(x0,y0)". Le choix du signe trac s'effectue
//	 travers la mthode "SelMarker()"
// void  DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)
//	Trac de "n" signes aux points "(x[i],y[i])"
//--

//++
// Titre	Trac d'images (pixmap)
//--
//++
// void  DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, int sx, int sy, PIColorMap* cmap)
//	Trac d'un pixmap dans un rectangle positionn en "(x,y)". Le tableau des pixels
//	"pix", de taille "sx,sy" reprsente les index dans la table de couleur "cmap".
//--

//++
// Titre	Modifications des attributs graphiques	
//--
//++
// void  SelForeground(PIColors col=PI_Black)
//	Choix de la couleur de trac d'avant-plan
//|	PI_Black , PI_White,  PI_Grey , PI_Red , PI_Blue , PI_Green ,  
//|	PI_Yellow , PI_Magenta , PI_Cyan , PI_Turquoise , PI_NavyBlue , 
//|	PI_Orange , PI_SiennaRed , PI_Purple , PI_LimeGreen , PI_Gold ,
//|	PI_ColorAllBits0 , PI_ColorAllBits1
// void  SelBackground(PIColors col=PI_White)
//	Choix de la couleur d'arrire-plan
// void  SelForeground(PIColorMap& cmap, int cid) 
//	Choix de la couleur de trac d'avant-plan: Couleur numro "cid" de la table de couleur "cmap"
// void  SelBackground(PIColorMap& cmap, int cid)
//	Choix de la couleur d'arrire-plan: Couleur numro "cid" de la table de couleur "cmap"
// void  SelGOMode(PIGOMode mod=PI_GOCopy) 
//	Choix du mode de trac graphique: "PI_GOCopy" ou "PI_GOXOR" ou 	"PI_GOInvert"
// void  SelLine(PILineAtt att=PI_NormalLine)
//	Choix du type de ligne pour le trac des lignes et contours
//|	PI_NormalLine, PI_ThinLine , PI_ThickLine
//|	PI_DashedLine, PI_ThinDashedLine, PI_ThickDashedLine
//|	PI_DottedLine, PI_ThinDottedLine, PI_ThickDottedLine
// void  SelMarker(int msz=3, PIMarker mrk=PI_DotMarker) 
//	Choix de la taille et du type de signe pour "DrawMarker() / DrawMarkers()"
//|	PI_DotMarker , PI_PlusMarker , PI_CrossMarker
//|	PI_CircleMarker , PI_FCircleMarker , PI_BoxMarker , PI_FBoxMarker
//|	PI_TriangleMarker , PI_FTriangleMarker , PI_StarMarker , PI_FStarMarker
//	(Les "StarMaker" ne sont pas encore implments  11/98) 
//--

//++
// Titre	Changement de fontes
//--
//++
// void  SelFont(PIFont & fnt)
//	Choix de fonte courant.
// void  SelFont(PIFontSize sz=PI_NormalSizeFont, PIFontAtt att=PI_RomanFont)
//	Changement de taille et attribut de fonte
//|	PI_SmallSizeFont , PI_NormalSizeFont , PI_BigSizeFont, PI_HugeSizeFont
//|	PI_RomanFont , PI_BoldFont , PI_ItalicFont 
// void  SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont)
//	Choix de taille de fonte avec spcification de taille en points 
//	(pixels sur l'cran)
// 
//--

//++
// Titre	Slection de la zone de trac (clip)	
//--
//++
// void  SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Limite la zone de trac permise au rectangle "(x0,y0)", "dx,dy"
// void  ClearClipRectangle() 
//	Supprime si ncssaire la limitation de la zone de trac.	
//--

//++
// Titre	Accs aux attributs graphiques
//--
//++
// PIColors  GetForeground()
//	Renvoie la couleur de trac d'avant-plan courante. 
//	("PI_ColorFromMap" si dfini  partir d'une table de couleur
// PIColors  GetBackground()
//	Renvoie la couleur d'arrire-plan courante.
// PIGOMode  GetGOMode()
//	Renvoie le mode de trac graphique courante.
// PIFontAtt GetFontAtt()
//	Renvoie les attributs de la fonte courante.
// int GetFontSize() 
//	Renvoie la taille de la fonte courante.
// PILineAtt GetLineAtt() 
//	Renvoie le type de ligne courant
// PIMarker  GetMarker() 
//	Renvoie le type de signe (Marker) courant
// int GetMarkerSize()
//	Renvoie la taille des signes (Marker) pour le marker courant
// PIFont  GetFont()
//	Retourne une copie de l'objet "PIFont" courant.
// PIGrCoord  GetFontHeight(PIGrCoord& asc, PIGrCoord& desc);
//	Renvoie la hauteur des caractres, ainsi que la taille au dessus
//	et en-dessous de la ligne de base ("asc , desc") pour la fonte courante
//	dans le systme de coordonnes courant (Fentre ou UC).
// PIGrCoord CalcStringWidth(char const* s)
//	Renvoie la largeur occup par un texte s'il tait affich dans le 
//	systme de coordonnes courant (Fentre ou UC).
//--

/* --Methode-- */
PIGrCoord PIGraphicGen::GetFontHeight(PIGrCoord& asc, PIGrCoord& desc)
{
int t,a,d;
t = myFont.GetFontHeight(a, d);
asc = a;   desc = d;
return(t);
}

/* --Methode-- */
PIGrCoord PIGraphicGen::CalcStringWidth(char const* s)
{
return (myFont.GetStringWidth(s));
}

/* --Methode-- */
bool PIGraphicGen::CalcStringPositionShift(char const* s, int pos, 
					   int& dx, int& dy)
{
  dx = 0;
  dy = 0;
  if (pos == 0) return(false);
  else {
    int posh = pos & PI_HorizontalPosition;
    int posv = pos & PI_VerticalPosition;
    if ( ((posh == 0) &&  (posv == PI_VerticalBaseLine)) || 
	 ((posh == PI_HorizontalLeft) && (posv == 0)) ||
	 ((posh == PI_HorizontalLeft) && (posv == PI_VerticalBaseLine)) )
      return(false);
    if (posh != PI_HorizontalLeft) {
      int wx = myFont.GetStringWidth(s);
      if (posh == PI_HorizontalCenter)  dx = wx/2;
      else if (posh == PI_HorizontalRight)  dx = wx;
      else wx = 0;
    }
    if (posv != PI_VerticalBaseLine) {
      int asc,desc;
      int wy = myFont.GetFontHeight(asc, desc);
      if (posv == PI_VerticalBottom) dy = desc;
      else if (posv == PI_VerticalCenter)  dy = -wy/2+desc;
      else if (posv == PI_VerticalTop)  dy = -wy+desc;
      else dy = 0;
    }
    return(true);
  }
}


//++
// Titre	Sauvegarde et rappel des attributs graphiques
//--
//++
// void  SaveGraphicAtt()
//	Sauvegarde des attributs graphiques courants
// void  RestoreGraphicAtt()
//	Utilisation de l'ensemble des attributs graphiques sauvegards par un appel
//	 "SaveGraphicAtt()"
//--


/* --Methode-- */
void PIGraphicGen::SaveGraphicAtt()
{
  sFCol = GetForeground();
  sBCol = GetBackground();
  sGOm = GetGOMode();
  sFont = GetFont();   
  sLAtt = GetLineAtt();
  sMrk = GetMarker();   
  sMrkSz = GetMarkerSize();
  return;
}

/* --Methode-- */
void PIGraphicGen::RestoreGraphicAtt()
{
  SelForeground(sFCol);
  SelBackground(sBCol);
  SelGOMode(sGOm);
  SelFont(sFont);
  SelLine(sLAtt);
  SelMarker(sMrkSz, sMrk);
  return;
}




//++
// Class	PIGrCoord
// Lib		PI
// include	pigraphgen.h
//
//   	Classe utilis pour la spcifiaction de coordonnes graphique.
//	Des constructeurs et des mthodes de conversion  partir 
//	et vers des "int", "float" et "double" sont dfinis.
//	L'objet conserve le type effectif de l'argument lors de la 
//	cration ou de la dernire affectation.
// 
//|	PIGrCoord gco;
//|	gco = 3.141596 ; 
//|	int ic = gco;     // ic -> 3
//|	float fc = gco;   // fc -> 3.141596
//--
//++
// Links	Voir aussi
// PIGraphic
//--

//++
// Titre	Constructeurs
//--
//++
// 
// PIGrCoord() 
//	Constructeur par dfaut ("intVal=floatVal=0")
// PIGrCoord(int a)
//	Constructeur  partir de l'entier "a"
// PIGrCoord(float a) 
//	Constructeur  partir de la valeur flottante "a"
// PIGrCoord(double a) 
//	Constructeur  partir de la valeur flottante double prcision "a"
//--
//++
// Titre	Oprateurs de conversion
//--
//++
// operator int() 
//	Conversion en entier "int"
// operator short() 
//	Conversion en entier "short"
// operator unsigned int() 
//	Conversion en entier non sign "unsigned int"
// operator unsigned short() 
//	Conversion en entier non sign "unsigned short"
// operator float() 
//	Conversion en rl "float"
// operator double() 
//	Conversion en rl "double"
//--
//++
// Titre	Oprateurs d'affectation
//--
//++
// PIGrCoord& operator= (int a) 
//	Affectation  partir de valeur entire "int"
// PIGrCoord& operator= (float a) 
//	Affectation  partir de valeur rlle "float"
// PIGrCoord& operator= (double a) 
//	Affectation  partir de valeur rlle double prcision "double"
//--
