// Classe traceur d histogramme                 96-99
// CEA-DAPNIA      LAL-IN2P3/CNRS

#include <stdio.h>
#include <typeinfo>

#include "pihisto.h"
#include "hisprof.h"

//++
// Class	PIHisto
// Lib		PIext
// include	pihisto.h
//
//	Classe traceur d'objet histogramme (classe *Histo*)
//--
//++
// Links	Parents
// PIDrawer
//--
//++
// Titre	Constructeur, mthodes
//--
//++
// PIHisto(Histo* histo, bool ad=false)
//	Constructeur. Si "ad == true", l'objet "histo" est dtruit par 
//	le destructeur de l'objet "PIHisto"
//	Note : "histo" doit tre cr par new
//
// void  SetStats(bool fg=true) 
//	Active/ dsactive l'indication des statistiques d'histogramme
//--


PIHisto::PIHisto(Histo* histo, bool ad)
: PIDrawer(), mHisto(histo)
{
  mAdDO = ad;     // Flag pour suppression automatique de mHisto
  SetStats(true);
  SetName("HistoDrw");
}

PIHisto::~PIHisto()
{
  if (mAdDO) delete mHisto;
}

void
PIHisto::UpdateLimits()
{
  if (!mHisto)  return;
  float hmin = mHisto->VMin();
  float hmax = mHisto->VMax()+0.2*(mHisto->VMax()-mHisto->VMin());
  // si HBProf min,max calcules en tenant compte des erreurs
  if( typeid(*mHisto) == typeid(HProf) ) {
    float v1,v2;
    for (int i=1; i<mHisto->NBins(); i++) {
      v1 = (*mHisto)(i) - mHisto->Error(i);
      v2 = (*mHisto)(i) + mHisto->Error(i);
      if(v1<hmin) hmin = v1;
      if(v2>hmax) hmax = v2;
    }
    v1 = 0.1*(hmax-hmin);
    hmin -= v1;   hmax += v1;
  }
  if(hmax<=hmin) hmax += 1.;
  SetLimits(mHisto->XMin(), mHisto->XMax(), hmin, hmax);
//  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);   NE PAS faire Reza 11/99
}

void
PIHisto::Draw(PIGraphicUC* g, double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
  if (axesFlags != kAxesNone) DrawAxes(g);

  bool oktrace = false;
  if (!mHisto)  return;  

  if(mMrk != PI_NotDefMarker ||  (typeid(*mHisto) == typeid(HProf)) ) {
    // Marqeurs definis OU HProf => marqueurs+Erreurs si il y en a
    mHisto->UpdateHisto(); // pour le cas ou c'est un HProf
    if(mLAtt == PI_NotDefLineAtt) g->SelLine(PI_ThinLine);
    double x1,y1, x2,y2;
    double bw = mHisto->BinWidth();
    for(int i=0; i<mHisto->NBins(); i++) {
      if(mHisto->Error(i)>0.) {
        // barres d'erreur verticales
        x1 = x2 = mHisto->BinCenter(i);
        y1 = (*mHisto)(i) - mHisto->Error(i);
        y2 = (*mHisto)(i) + mHisto->Error(i);
        g->DrawLine(x1,y1, x1, y2);
        // limites de barres d'erreurs (horizontales)
        x1 -= bw/3.;  x2 += bw/3.;
        g->DrawLine(x1,y1, x2, y1);
        g->DrawLine(x1,y2, x2, y2);
      }
      // le marqueur
      x1 = mHisto->BinCenter(i);
      y1 = (*mHisto)(i);
      g->DrawMarker(x1,y1);
    }
    oktrace = true;
  }
  if(mLAtt != PI_NotDefLineAtt) {
    double x1,y1, x2, y2;
    x1 = mHisto->BinLowEdge(0);
    y1 = 0;
    for(int i=0; i<mHisto->NBins(); i++) {
      x2 = x1;
      y2 = (*mHisto)(i);
      g->DrawLine(x1,y1, x2, y2);
      y1 = y2;
      x2 = mHisto->BinHighEdge(i);
      g->DrawLine(x1,y1, x2, y2);
      x1 = x2;
    }
    y2 = 0; g->DrawLine(x1,y1, x2, y2);
    oktrace = true;
  }
  if( !oktrace ) {
    for(int i=0; i<mHisto->NBins(); i++) {
      double left   = mHisto->BinLowEdge(i);
      double width  = mHisto->BinWidth();
      double bottom = 0;
      double height = (*mHisto)(i);
      g->DrawFBox(left,bottom,width,height);
      g->DrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
    }
  }
  // A faire a la fin - DrawStats change l'attribut de ligne 
  if(stats) DrawStats(g);
}

void
PIHisto::DrawStats(PIGraphicUC* g)
{
  if (!mHisto) return;
  //  if (mLAtt == PI_NotDefLineAtt)  g->SelLine(PI_ThinLine);
  g->SelLine(PI_ThinLine);
  g->SelFontSz((YMax() - YMin())/30, mFAtt);

  // La hauteur de la cellule
  PIGrCoord a, d;
  double cH = (double)g->GetFontHeight(a,d);
  double cellHeight = 3.6 * cH;

  // Les labels et leurs longueurs -> largeur de la cellule
  char *label, label1[64], label2[64], label3[64];
  sprintf(label1, "N= %-g",mHisto->NData());
  sprintf(label2, "m= %-g",mHisto->Mean());
  sprintf(label3, "s= %-g",mHisto->Sigma());
  label = label1;
  if(strlen(label)<strlen(label2)) label = label2;
  if(strlen(label)<strlen(label3)) label = label3;
  double cellWidth =  1.1 * (double)g->CalcStringWidth(label);

  double xu, yu, cw;
  // Les limites du cadre
  xu = g->DeltaUCX(XMax(), -cellWidth);
  yu = g->DeltaUCY(YMax(), -cellHeight);
  g->DrawLine(xu,YMax(),xu,yu);
  g->DrawLine(xu,yu,XMax(),yu);

  // L'ecriture des labels (attention aux inversions possibles des axes!)
  cw = (g->isAxeXDirRtoL()) ? -0.05*cellWidth : -0.95*cellWidth;
  xu = g->DeltaUCX(XMax(),cw);

  cw = (g->isAxeYDirUpDown()) ? -0.15*cH : -1.15*cH;
  yu = g->DeltaUCY(YMax(),cw);
  g->DrawString(xu, yu,label1);
    cw +=  -1.15*cH;
    yu = g->DeltaUCY(YMax(),cw);
    g->DrawString(xu, yu,label2);
      cw +=  -1.15*cH;
      yu = g->DeltaUCY(YMax(),cw);
      g->DrawString(xu, yu,label3);
                       
}
