#include "meanvarestim.h"
#include "toimanager.h"
#include "slinparbuff.h"

MeanVarEstimator::MeanVarEstimator(int n) {
  nsamples = n;
}

void MeanVarEstimator::init() {
  declareInput("signal");
  declareOutput("mean");
  declareOutput("variance");
  name = "MeanEstimator";

  neededHistory = nsamples;
}

void MeanVarEstimator::run() {
  int snb = getMinIn();
  int sne = getMaxIn();

  cout << "MeanVarEstimator -- " << snb << " to " << sne << endl;

  bool hasMean = checkOutputTOIIndex(0);
  bool hasVar  = checkOutputTOIIndex(1);

  if (snb>sne) {
    cout<<"MeanVarEstimator::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
    throw ParmError("MeanVarEstimator::run() - Bad sample interval");
  }

  if (!checkInputTOIIndex(0)) {
    cout<<"MeanVarEstimator::run() - Input TOI (signal) not connected! "<<endl;
    throw ParmError("MeanVarEstimator::run() Input TOI (signal) not connected!");
  }


  if (!hasMean && !hasVar) {
    cerr << " MeanVarEstimator::run() - No Output TOI connected! "
         << endl;
    throw ParmError("MeanVarEstimator::run() No output TOI connected!");
  }
  
  if (sne-snb < nsamples) {
    cerr << "MeanVarEstimator::run() -  sne-snb < nsamples!" << endl;
    throw ParmError("MeanVarEstimator::run() -  sne-snb < nsamples!");
  }
  
  SLinParBuff slb(nsamples, 100, 0., 0., true);    
  
  for (int sn=snb; sn<=sne; sn++) {
    r_8 sg; uint_8 fg=0;
    getData(0,sn,sg,fg);
    
    if (fg&flgNotLookAt) slb.Pop();
    else slb.Push((r_8)sn,sg);

    r_8 mean;
    r_8 sig = slb.Compute(mean);
    
    if (hasMean)
      putData(0, sn, mean, fg);
    if (hasVar)
      putData(1, sn, sig*sig, fg);
  }
}

