#include "noisegen.h"
#include "toimanager.h"

NoiseGen::NoiseGen() {
  gen = NULL;
}

NoiseGen::~NoiseGen() {
  delete gen;
}

void NoiseGen::init() {
  declareOutput("noise");
  name = "NoiseGen";
}

int NoiseGen::calcMinOut() {
  chkinit();
  TOIManager* mgr = TOIManager::getManager();
  int firstReq = mgr->getRequestedBegin();
  return firstReq;
}

int NoiseGen::calcMaxOut() {
  chkinit();
  TOIManager* mgr = TOIManager::getManager();
  int lastReq = mgr->getRequestedEnd();
  return lastReq;
}

void NoiseGen::run() {
  if (gen == NULL) {
    cerr << "NoiseGen::run  : no generator" << endl;
    abort();
  }

  int snb = getMinOut();
  int sne = getMaxOut();

  cout << " NoiseGen::run() SNRange=" << snb << " - " << sne << endl; 

  for (int i=snb; i<=sne; i++) {
    putData(0,i,gen->Noise(),0);
  }
  
}

NoiseGenGauss::NoiseGenGauss(float sigma) {
  gen = new SOPHYA::NoiseGenerator(sigma);
}

NoiseGenOOF::NoiseGenOOF(float fknee, float sigma ) {
  float tau=0.5/fknee;
  if (tau < 1) tau=1;
  gen = new SOPHYA::SumNoise(fknee, sigma, tau);
}
