// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: noisegen.h,v 1.1 2002-01-15 00:46:25 aubourg Exp $

#ifndef NOISEGEN_H
#define NOISEGEN_H

#include "toiprocessor.h"

#include "bruit.h"

class NoiseGen : public TOIProcessor {
public:
  NoiseGen();
  virtual ~NoiseGen();

  virtual void init();
  virtual void run();

protected:
  SOPHYA::NoiseGenerator* gen;

  virtual int   calcMinOut();
  virtual int   calcMaxOut();
};

class NoiseGenGauss : public NoiseGen {
public:
  NoiseGenGauss(float sigma);
};

class NoiseGenOOF : public NoiseGen {
public:
  NoiseGenOOF(float fknee, float sigma);
};




#endif


