#include <stdlib.h>
#include <stdio.h>

#include <exception>
#include <string>

#include <iostream.h>
#include <vector>
#include <map>
#include <complex>

// :::::::::::::::::::::::::::::::::::::::::::::::::::::
// Test du support de la STL par le compilateur 
// string, vector<T>, map<T>, complex<T> exception 
// :::::::::::::::::::::::::::::::::::::::::::::::::::::
 
using namespace std;

// --------------------------------------------------------------------
// definition d'une classe de conversion de C (complexes) <> R (reel) 
class convCR {
public:
  inline convCR() { dv = 0.;  dv_im = 0.; }  
  inline convCR(float v) { dv = (double)v;  dv_im = 0.; }  
  inline convCR(double v) { dv = v;  dv_im = 0.; }  
  inline convCR(complex<float> const & z) { dv = (double)z.real();  dv_im = (double)z.imag(); }  
  inline convCR(complex<double> const & z) { dv = z.real();  dv_im = z.imag(); }
  inline float  operator= (float v) { dv = (double)v;  dv_im = 0.; return v; }
  inline double operator= (double v) { dv = v;  dv_im = 0.; return v; }
  inline complex<float>  operator= (complex<float> const & z) 
   { dv = (double)z.real(); dv_im = (double)z.imag(); return z; }
  inline complex<double>  operator= (complex<double> const & z) 
   { dv = z.real(); dv_im = z.imag(); return z; }

  inline operator float() const  { return((float)dv); }
  inline operator double() const  { return(dv); }
  inline operator complex<float>() const { return(complex<float>((float)dv, (float)dv_im)); }
  inline operator complex<double>() const { return(complex<double>(dv, dv_im)); }
  inline complex<float> ToComplexF() const { return(complex<float>((float)dv, (float)dv_im)); }  
  inline complex<double> ToComplexD() const { return(complex<double>(dv, dv_im)); }  
  double dv;
  double dv_im;   /* for holding imaginary part of a complex */
};
// --------------------------------------------------------------------

int main(int narg, char *arg[])
{
  cout << "\n :::::::: Test complex / vector et map de la stl :::::::: \n" ;
  int rc = 0;
  try {
    vector<int> vi;
    int k;
    for(k=0; k<5; k++)    vi.push_back(k*5);
    cout << " -----> vector<int> vi.size() = " << vi.size() << endl;
    for(k=0; k<vi.size(); k++)
      cout << "vi[" << k << "]= " << vi[k] << endl;
    map<string, int> msi;
    msi["Un"] = 1;
    msi["Deux"] = 2;
    msi["Cinq"] = 5;
    msi["Douze"] = 12;
    map<string, int>::iterator it;
    cout << " -----> map<string, int> msi.size() = " << msi.size() << endl;
    for(it=msi.begin(); it!=msi.end(); it++)
      cout << " S= " << (*it).first << " I=" << (*it).second << endl;
    cout << " ---->  complex numbers and convCR : " << endl;
    complex<float> z,z1(2,2),z2(3,-1);
    complex<double> zd,zd1(2.5,2.5),zd2(3.3,-1);
    cout << " complex<float>: z1=" << z1 << " z2=" << z2 
	 << " z1+z2=" << z1+z2 << endl;
    cout << " complex<double>: z1=" << zd1 << " z2=" << zd2 
	 << " zd1+zd2=" << zd1+zd2 << endl;
    convCR czr, czr1(z1), czr2(zd2), czr3;
    /* if defined(__GNUG__) && (__GNUC__ < 3) */
#if defined(__GNUG__) 
    complex<float> za;
    complex<double> zb,zc;
    za = czr1.ToComplexF(); zb = czr1.ToComplexD(); zc = czr2.ToComplexD();  
    cout << " GNUG_Version: __GNUC__ = " << __GNUC__ << endl;
    cout << " convCR: za=(zb)=czr1" << za << " zc=" << zc 
    << " zb+zc=" << zb+zc << endl ; 
#else
    cout << " convCR: czr1(z1)" << (complex<float>)czr1
	 << " czr2(z2)" << (complex<double>)czr2 
	 << " czr1+czr2= " << (complex<double>)czr2+(complex<double>)czr1 << endl;
#endif
  }
  catch(exception exc){
  // Classe de base des exception standard - 
  // La methode what() n'est pas forcement conforme a la norme 
    string msg = exc.what();
    cerr << " Catched exception : msg= " << msg << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " Catched Unknown exception ! " << endl;
    rc = 99;
  }

  cout << " ::::::::: Exiting from vecmapstl.cc ::::::::: \n" << endl;
  exit(rc);
}








