// This may look like C code, but it is really -*- C++ -*-
// Module PIext :   PIHisto2D PIH2DWdg 
// Traceur Histo-2D    C. Magneville 97-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIHISTO2D_H
#define PIHISTO2D_H

#include "pisysdep.h"
#include PIMENU_H 
#include PIMENUBAR_H 
#include PIOPTMENU_H

#include "histos2.h"
#include "piscdrawwdg.h"

////////////////////////////////////////////////////////////////////
class PIHisto2D : public PIDrawer {
public:
  PIHisto2D(Histo2D* histo, bool ad=false);
  virtual ~PIHisto2D();

  void UseColors(bool fg=false,CMapId cmap=CMAP_GREYINV32,bool revcmap=false);
  void UseScale(unsigned short type=0,float logscale=10.);
  void UseDisplay(unsigned short type=0,float fnpt=0.5);
  void UseDyn(float hmin=1.,float hmax=-1.);
  void UseFrac(float frmin=0.1,float frmax=0.9);
  void Print(int lp=0);

  virtual void Draw(PIGraphicUC* g,double xmin,double ymin,double xmax,double ymax);

  //   AppendTextInfo a faire un jour - Reza 21/01/2002 
  //  virtual void AppendTextInfo(string& info, double xmin, double ymin, double xmax, double ymax);
  virtual void GetClickInfo(string& info, double x, double y); // Info pour position X,Y

  virtual void UpdateLimits();
  virtual void DrawStats(PIGraphicUC* g);

//  Methode permettant l'affichage d'une fenetre de controle specialisee 
  virtual void ShowControlWindow(PIBaseWdgGen* wdg);

  inline Histo2D*       Histogram()   {return(mHisto);}
  inline bool           Color()       {return(mFgCol);}
  inline CMapId         ColMap()      {return(mCmap);}
  inline bool           IsColMapRev() {return(mRevCmap);}
  inline unsigned short TypScale()    {return(mTypScal);}
  inline unsigned short TypDisplay()  {return(mTypDisp);}
  inline float          FPoints()     {return(mFPoints);}
  inline float          HMax()        {return(mHMax);}
  inline float          HMin()        {return(mHMin);}
  inline float          FMax()        {return(mFracMax);}
  inline float          FMin()        {return(mFracMin);}
  inline float          LogScale()    {return(mLogScale);}

protected:
  int NPixBin(PIGraphicUC* g);
  char HPrint2(float f);

  Histo2D* mHisto;
  bool mAdDO;
  bool mFgCol; CMapId mCmap; bool mRevCmap;
  unsigned short mTypScal; float mLogScale;
  unsigned short mTypDisp; float mFPoints;
  float mHMin,mHMax;
  float mFracMin,mFracMax;
};

////////////////////////////////////////////////////////////////////
/*
// NOT USED ANYMORE... KEEP IT FOR MEMORY
class PIH2DWdg : public PIScDrawWdg {
public:
  PIH2DWdg(PIContainerGen *par,const char *nom,int sx=300,int sy=300,int px=0,int py=0);
  ~PIH2DWdg();
  void SetHisto(Histo2D* histo);
  void SetPIHisto(PIHisto2D* pih2);
  inline PIHisto2D* GetPIHisto() {return mPih;}
  virtual string GetClickText(double x, double y); 
  virtual void	 ActivateSpecializedControls(); // Pour activer des controles specifiques
  virtual void   But3Press(int x, int y);
protected:
  PIHisto2D*  mPih;
};
*/

////////////////////////////////////////////////////////////////////
class H2WinArg : public PIWindow {
public :
  H2WinArg(PIMsgHandler* par);
  ~H2WinArg();

  static void ShowPIHisto2DTools();
  static void ShowPIHisto2DTools(PIBaseWdgGen* cbw);
  static void HidePIHisto2DTools();
  static void SetCurrentBaseWdg(PIBaseWdgGen* cbw);
  static void SetCurrentPIHisto2D(PIHisto2D* h2ddrw);

  static PIBaseWdgGen* GetCurrentBaseWdg();
  static PIHisto2D* GetCurrentPIHisto2D();

  void SetText();

  virtual void Show();
  virtual void Process(PIMessage msg,PIMsgHandler* sender,void* data=NULL);

protected:
  static PIBaseWdgGen * mBWdg;
  static PIHisto2D*  mH2DDrw;

  PIOptMenu * mOPop[3];
  PIMenu    * mCasc[2];
  PIButton  * mBut[4];
  PILabel   * mLab[4];
  PIText    * mText[3];
  PIScale   * mPScal;
  PICheckBox* mCkb;

  bool mFgCol; CMapId mCmap; bool mRevCmap;
  unsigned short mTypScal; float mLogScale;
  unsigned short mTypDisp; float mFPoints;
  float mHMin,mHMax;
  float mFracMin,mFracMax;
};

#endif
