#ifndef PIGRAPHICPS_H_SEEN
#define PIGRAPHICPS_H_SEEN

#include "pisysdep.h"
#include "pigraphgen.h"
#include "psfile.h"

class PIGraphicPS : public PIGraphicGen
{
public:
                     PIGraphicPS(PSFile * psf, PIWdg* wdg, double ofx=0., double ofy=0.,
				 double scale_x=1., double scale_y=1.);
                     PIGraphicPS(PSFile * psf, double x0, double y0, double dx, double dy);
  virtual           ~PIGraphicPS();

  virtual int        kind();

//  Espace des coordonnees
  virtual void       GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax); 

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0);
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0);
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy,
                             double degdeb, double degfin);
  virtual void       DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                              double degdeb, double degfin);
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0);
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n);
  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelForeground(PIColorMap& cmap, int cid);
  virtual void       SelBackground(PIColorMap& cmap, int cid);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelLine(PILineAtt const& att);
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker);

  virtual void       SelFont(PIFont & fnt);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PILineAtt  GetLineAtt();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

  //  virtual PIGrCoord  GetFontHeight(PIGrCoord& asc, PIGrCoord& desc);
  //  virtual PIGrCoord  CalcStringWidth(char const* s);

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

protected:
  void           BuildFromPSFile(PSFile * psf, double x0, double y0, double tx, double ty,
				 double dx, double dy);

  PSFile * mPSOut;  /* Fichier PostScript */
  double mXmin, mYmin;
  double mXmax, mYmax;

  PIColors  mFCol, mBCol;
  PIColor  mFCfMap, mBCfMap;
  PIGOMode mGOm;
//  PIFontAtt mFAtt;  Plus besoin Reza + NR 07/08/99
  PILineAtt mLAtt;
//  int mFSize;    Plus besoin Reza + NR 07/08/99
  PIMarker mMrk;
  int mMrkSz;
};


#endif
